% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_create_participant}
\alias{connect_create_participant}
\title{Adds a new participant into an on-going chat contact}
\usage{
connect_create_participant(
  InstanceId,
  ContactId,
  ClientToken = NULL,
  ParticipantDetails
)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance. You can \href{https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html}{find the instance ID}
in the Amazon Resource Name (ARN) of the instance.}

\item{ContactId}{[required] The identifier of the contact in this instance of Amazon Connect. Only
contacts in the CHAT channel are supported.}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. If not provided, the Amazon Web Services SDK
populates this field. For more information about idempotency, see
\href{https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/}{Making retries safe with idempotent APIs}.}

\item{ParticipantDetails}{[required] Information identifying the participant.

The only Valid value for \code{ParticipantRole} is \code{CUSTOM_BOT}.

\code{DisplayName} is \strong{Required}.}
}
\description{
Adds a new participant into an on-going chat contact. For more information, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html}{Customize chat flow experiences by integrating custom participants}.

See \url{https://www.paws-r-sdk.com/docs/connect_create_participant/} for full documentation.
}
\keyword{internal}
