% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connect_operations.R
\name{connect_start_task_contact}
\alias{connect_start_task_contact}
\title{Initiates a contact flow to start a new task}
\usage{
connect_start_task_contact(InstanceId, PreviousContactId, ContactFlowId,
  Attributes, Name, References, Description, ClientToken)
}
\arguments{
\item{InstanceId}{[required] The identifier of the Amazon Connect instance.}

\item{PreviousContactId}{The identifier of the previous chat, voice, or task contact.}

\item{ContactFlowId}{[required] The identifier of the contact flow for initiating the tasks. To see the
ContactFlowId in the Amazon Connect console user interface, on the
navigation menu go to \strong{Routing}, \strong{Contact Flows}. Choose the contact
flow. On the contact flow page, under the name of the contact flow,
choose \strong{Show additional flow information}. The ContactFlowId is the
last part of the ARN, shown here in bold:

arn:aws:connect:us-west-2:xxxxxxxxxxxx:instance/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx/contact-flow/\strong{846ec553-a005-41c0-8341-xxxxxxxxxxxx}}

\item{Attributes}{A custom key-value pair using an attribute map. The attributes are
standard Amazon Connect attributes, and can be accessed in contact flows
just like any other contact attributes.

There can be up to 32,768 UTF-8 bytes across all key-value pairs per
contact. Attribute keys can include only alphanumeric, dash, and
underscore characters.}

\item{Name}{[required] The name of a task that is shown to an agent in the Contact Control
Panel (CCP).}

\item{References}{A formatted URL that is shown to an agent in the Contact Control Panel
(CCP).}

\item{Description}{A description of the task that is shown to an agent in the Contact
Control Panel (CCP).}

\item{ClientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\value{
A list with the following syntax:\preformatted{list(
  ContactId = "string"
)
}
}
\description{
Initiates a contact flow to start a new task.
}
\section{Request syntax}{
\preformatted{svc$start_task_contact(
  InstanceId = "string",
  PreviousContactId = "string",
  ContactFlowId = "string",
  Attributes = list(
    "string"
  ),
  Name = "string",
  References = list(
    list(
      Value = "string",
      Type = "URL"
    )
  ),
  Description = "string",
  ClientToken = "string"
)
}
}

\keyword{internal}
