% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_list_identities}
\alias{ses_list_identities}
\title{Returns a list containing all of the identities (email addresses and
domains) for your AWS account in the current AWS Region, regardless of
verification status}
\usage{
ses_list_identities(IdentityType, NextToken, MaxItems)
}
\arguments{
\item{IdentityType}{The type of the identities to list. Possible values are "EmailAddress"
and "Domain". If this parameter is omitted, then all identities will be
listed.}

\item{NextToken}{The token to use for pagination.}

\item{MaxItems}{The maximum number of identities per page. Possible values are 1-1000
inclusive.}
}
\value{
A list with the following syntax:\preformatted{list(
  Identities = list(
    "string"
  ),
  NextToken = "string"
)
}
}
\description{
Returns a list containing all of the identities (email addresses and
domains) for your AWS account in the current AWS Region, regardless of
verification status.

You can execute this operation no more than once per second.
}
\section{Request syntax}{
\preformatted{svc$list_identities(
  IdentityType = "EmailAddress"|"Domain",
  NextToken = "string",
  MaxItems = 123
)
}
}

\examples{
\dontrun{
# The following example lists the email address identities that have been
# submitted for verification with Amazon SES:
svc$list_identities(
  IdentityType = "EmailAddress",
  MaxItems = 123L,
  NextToken = ""
)
}

}
\keyword{internal}
