% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ses_operations.R
\name{ses_send_templated_email}
\alias{ses_send_templated_email}
\title{Composes an email message using an email template and immediately queues
it for sending}
\usage{
ses_send_templated_email(Source, Destination, ReplyToAddresses,
  ReturnPath, SourceArn, ReturnPathArn, Tags, ConfigurationSetName,
  Template, TemplateArn, TemplateData)
}
\arguments{
\item{Source}{[required] The email address that is sending the email. This email address must be
either individually verified with Amazon SES, or from a domain that has
been verified with Amazon SES. For information about verifying
identities, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html}{Amazon SES Developer Guide}.

If you are sending on behalf of another user and have been permitted to
do so by a sending authorization policy, then you must also specify the
\code{SourceArn} parameter. For more information about sending authorization,
see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html}{Amazon SES Developer Guide}.

Amazon SES does not support the SMTPUTF8 extension, as described in
\href{https://tools.ietf.org/html/rfc6531}{RFC6531}. For this reason, the
\emph{local part} of a source email address (the part of the email address
that precedes the @ sign) may only contain \href{https://en.wikipedia.org/wiki/Email_address#Local-part}{7-bit ASCII characters}. If
the \emph{domain part} of an address (the part after the @ sign) contains
non-ASCII characters, they must be encoded using Punycode, as described
in \href{https://tools.ietf.org/html/rfc3492.html}{RFC3492}. The sender name
(also known as the \emph{friendly name}) may contain non-ASCII characters.
These characters must be encoded using MIME encoded-word syntax, as
described in\href{https://tools.ietf.org/html/rfc2047}{RFC 2047}. MIME
encoded-word syntax uses the following form:
\verb{=?charset?encoding?encoded-text?=}.}

\item{Destination}{[required] The destination for this email, composed of To:, CC:, and BCC: fields. A
Destination can include up to 50 recipients across these three fields.}

\item{ReplyToAddresses}{The reply-to email address(es) for the message. If the recipient replies
to the message, each reply-to address will receive the reply.}

\item{ReturnPath}{The email address that bounces and complaints will be forwarded to when
feedback forwarding is enabled. If the message cannot be delivered to
the recipient, then an error message will be returned from the
recipient's ISP; this message will then be forwarded to the email
address specified by the \code{ReturnPath} parameter. The \code{ReturnPath}
parameter is never overwritten. This email address must be either
individually verified with Amazon SES, or from a domain that has been
verified with Amazon SES.}

\item{SourceArn}{This parameter is used only for sending authorization. It is the ARN of
the identity that is associated with the sending authorization policy
that permits you to send for the email address specified in the \code{Source}
parameter.

For example, if the owner of \code{example.com} (which has ARN
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}) attaches a
policy to it that authorizes you to send from \code{user@example.com}, then
you would specify the \code{SourceArn} to be
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}, and the
\code{Source} to be \code{user@example.com}.

For more information about sending authorization, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html}{Amazon SES Developer Guide}.}

\item{ReturnPathArn}{This parameter is used only for sending authorization. It is the ARN of
the identity that is associated with the sending authorization policy
that permits you to use the email address specified in the \code{ReturnPath}
parameter.

For example, if the owner of \code{example.com} (which has ARN
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}) attaches a
policy to it that authorizes you to use \code{feedback@example.com}, then you
would specify the \code{ReturnPathArn} to be
\code{arn:aws:ses:us-east-1:123456789012:identity/example.com}, and the
\code{ReturnPath} to be \code{feedback@example.com}.

For more information about sending authorization, see the \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/sending-authorization.html}{Amazon SES Developer Guide}.}

\item{Tags}{A list of tags, in the form of name/value pairs, to apply to an email
that you send using \code{SendTemplatedEmail}. Tags correspond to
characteristics of the email that you define, so that you can publish
email sending events.}

\item{ConfigurationSetName}{The name of the configuration set to use when you send an email using
\code{SendTemplatedEmail}.}

\item{Template}{[required] The template to use when sending this email.}

\item{TemplateArn}{The ARN of the template to use when sending this email.}

\item{TemplateData}{[required] A list of replacement values to apply to the template. This parameter is
a JSON object, typically consisting of key-value pairs in which the keys
correspond to replacement tags in the email template.}
}
\description{
Composes an email message using an email template and immediately queues
it for sending.

In order to send email using the \code{SendTemplatedEmail} operation, your
call to the API must meet the following requirements:
\itemize{
\item The call must refer to an existing email template. You can create
email templates using the CreateTemplate operation.
\item The message must be sent from a verified email address or domain.
\item If your account is still in the Amazon SES sandbox, you may only
send to verified addresses or domains, or to email addresses
associated with the Amazon SES Mailbox Simulator. For more
information, see \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html}{Verifying Email Addresses and Domains}
in the \emph{Amazon SES Developer Guide.}
\item The maximum message size is 10 MB.
\item Calls to the \code{SendTemplatedEmail} operation may only include one
\code{Destination} parameter. A destination is a set of recipients who
will receive the same version of the email. The \code{Destination}
parameter can include up to 50 recipients, across the To:, CC: and
BCC: fields.
\item The \code{Destination} parameter must include at least one recipient
email address. The recipient address can be a To: address, a CC:
address, or a BCC: address. If a recipient email address is invalid
(that is, it is not in the format
\emph{UserName@[SubDomain.]Domain.TopLevelDomain}), the entire message
will be rejected, even if the message contains other recipients that
are valid.
}

If your call to the \code{SendTemplatedEmail} operation includes all of the
required parameters, Amazon SES accepts it and returns a Message ID.
However, if Amazon SES can't render the email because the template
contains errors, it doesn't send the email. Additionally, because it
already accepted the message, Amazon SES doesn't return a message
stating that it was unable to send the email.

For these reasons, we highly recommend that you set up Amazon SES to
send you notifications when Rendering Failure events occur. For more
information, see \href{https://docs.aws.amazon.com/ses/latest/DeveloperGuide/send-personalized-email-api.html}{Sending Personalized Email Using the Amazon SES API}
in the \emph{Amazon Simple Email Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$send_templated_email(
  Source = "string",
  Destination = list(
    ToAddresses = list(
      "string"
    ),
    CcAddresses = list(
      "string"
    ),
    BccAddresses = list(
      "string"
    )
  ),
  ReplyToAddresses = list(
    "string"
  ),
  ReturnPath = "string",
  SourceArn = "string",
  ReturnPathArn = "string",
  Tags = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  ConfigurationSetName = "string",
  Template = "string",
  TemplateArn = "string",
  TemplateData = "string"
)
}
}

\keyword{internal}
