% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_savings_plans_utilization}
\alias{costexplorer_get_savings_plans_utilization}
\title{Retrieves the Savings Plans utilization for your account across date
ranges with daily or monthly granularity}
\usage{
costexplorer_get_savings_plans_utilization(
  TimePeriod,
  Granularity = NULL,
  Filter = NULL,
  SortBy = NULL
)
}
\arguments{
\item{TimePeriod}{[required] The time period that you want the usage and costs for. The \code{Start} date
must be within 13 months. The \code{End} date must be after the \code{Start} date,
and before the current date. Future dates can't be used as an \code{End}
date.}

\item{Granularity}{The granularity of the Amazon Web Services utillization data for your
Savings Plans.

The
\code{\link[=costexplorer_get_savings_plans_utilization]{get_savings_plans_utilization}}
operation supports only \code{DAILY} and \code{MONTHLY} granularities.}

\item{Filter}{Filters Savings Plans utilization coverage data for active Savings Plans
dimensions. You can filter data with the following dimensions:
\itemize{
\item \code{LINKED_ACCOUNT}
\item \code{SAVINGS_PLAN_ARN}
\item \code{SAVINGS_PLANS_TYPE}
\item \code{REGION}
\item \code{PAYMENT_OPTION}
\item \code{INSTANCE_TYPE_FAMILY}
}

\code{\link[=costexplorer_get_savings_plans_utilization]{get_savings_plans_utilization}}
uses the same
\href{https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_Expression.html}{Expression}
object as the other operations, but only \code{AND} is supported among each
dimension.}

\item{SortBy}{The value that you want to sort the data by.

The following values are supported for \code{Key}:
\itemize{
\item \code{UtilizationPercentage}
\item \code{TotalCommitment}
\item \code{UsedCommitment}
\item \code{UnusedCommitment}
\item \code{NetSavings}
}

The supported values for \code{SortOrder} are \code{ASCENDING} and \code{DESCENDING}.}
}
\description{
Retrieves the Savings Plans utilization for your account across date ranges with daily or monthly granularity. Management account in an organization have access to member accounts. You can use \code{\link[=costexplorer_get_dimension_values]{get_dimension_values}} in \code{SAVINGS_PLANS} to determine the possible dimension values.

See \url{https://paws-r.github.io/docs/costexplorer/get_savings_plans_utilization.html} for full documentation.
}
\keyword{internal}
