% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_reservation_purchase_recommendation}
\alias{costexplorer_get_reservation_purchase_recommendation}
\title{Gets recommendations for which reservations to purchase}
\usage{
costexplorer_get_reservation_purchase_recommendation(AccountId, Service,
  AccountScope, LookbackPeriodInDays, TermInYears, PaymentOption,
  ServiceSpecification, PageSize, NextPageToken)
}
\arguments{
\item{AccountId}{The account ID that is associated with the recommendation.}

\item{Service}{[required] The specific service that you want recommendations for.}

\item{AccountScope}{The account scope that you want recommendations for. \code{PAYER} means that
AWS includes the master account and any member accounts when it
calculates its recommendations. \code{LINKED} means that AWS includes only
member accounts when it calculates its recommendations.

Valid values are \code{PAYER} and \code{LINKED}.}

\item{LookbackPeriodInDays}{The number of previous days that you want AWS to consider when it
calculates your recommendations.}

\item{TermInYears}{The reservation term that you want recommendations for.}

\item{PaymentOption}{The reservation purchase option that you want recommendations for.}

\item{ServiceSpecification}{The hardware specifications for the service instances that you want
recommendations for, such as standard or convertible Amazon EC2
instances.}

\item{PageSize}{The number of recommendations that you want returned in a single
response object.}

\item{NextPageToken}{The pagination token that indicates the next set of results that you
want to retrieve.}
}
\description{
Gets recommendations for which reservations to purchase. These
recommendations could help you reduce your costs. Reservations provide a
discounted hourly rate (up to 75\\%) compared to On-Demand pricing.
}
\details{
AWS generates your recommendations by identifying your On-Demand usage
during a specific time period and collecting your usage into categories
that are eligible for a reservation. After AWS has these categories, it
simulates every combination of reservations in each category of usage to
identify the best number of each type of RI to purchase to maximize your
estimated savings.

For example, AWS automatically aggregates your Amazon EC2 Linux, shared
tenancy, and c4 family usage in the US West (Oregon) Region and
recommends that you buy size-flexible regional reservations to apply to
the c4 family usage. AWS recommends the smallest size instance in an
instance family. This makes it easier to purchase a size-flexible RI.
AWS also shows the equal number of normalized units so that you can
purchase any instance size that you want. For this example, your RI
recommendation would be for \code{c4.large} because that is the smallest size
instance in the c4 instance family.
}
\section{Request syntax}{
\preformatted{svc$get_reservation_purchase_recommendation(
  AccountId = "string",
  Service = "string",
  AccountScope = "PAYER"|"LINKED",
  LookbackPeriodInDays = "SEVEN_DAYS"|"THIRTY_DAYS"|"SIXTY_DAYS",
  TermInYears = "ONE_YEAR"|"THREE_YEARS",
  PaymentOption = "NO_UPFRONT"|"PARTIAL_UPFRONT"|"ALL_UPFRONT"|"LIGHT_UTILIZATION"|"MEDIUM_UTILIZATION"|"HEAVY_UTILIZATION",
  ServiceSpecification = list(
    EC2Specification = list(
      OfferingClass = "STANDARD"|"CONVERTIBLE"
    )
  ),
  PageSize = 123,
  NextPageToken = "string"
)
}
}

\keyword{internal}
