% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/costexplorer_operations.R
\name{costexplorer_get_anomaly_subscriptions}
\alias{costexplorer_get_anomaly_subscriptions}
\title{Retrieves the cost anomaly subscription objects for your account}
\usage{
costexplorer_get_anomaly_subscriptions(SubscriptionArnList, MonitorArn,
  NextPageToken, MaxResults)
}
\arguments{
\item{SubscriptionArnList}{A list of cost anomaly subscription ARNs.}

\item{MonitorArn}{Cost anomaly monitor ARNs.}

\item{NextPageToken}{The token to retrieve the next set of results. AWS provides the token
when the response from a previous call has more results than the maximum
page size.}

\item{MaxResults}{The number of entries a paginated response contains.}
}
\value{
A list with the following syntax:\preformatted{list(
  AnomalySubscriptions = list(
    list(
      SubscriptionArn = "string",
      AccountId = "string",
      MonitorArnList = list(
        "string"
      ),
      Subscribers = list(
        list(
          Address = "string",
          Type = "EMAIL"|"SNS",
          Status = "CONFIRMED"|"DECLINED"
        )
      ),
      Threshold = 123.0,
      Frequency = "DAILY"|"IMMEDIATE"|"WEEKLY",
      SubscriptionName = "string"
    )
  ),
  NextPageToken = "string"
)
}
}
\description{
Retrieves the cost anomaly subscription objects for your account. You
can filter using a list of cost anomaly monitor Amazon Resource Names
(ARNs).
}
\section{Request syntax}{
\preformatted{svc$get_anomaly_subscriptions(
  SubscriptionArnList = list(
    "string"
  ),
  MonitorArn = "string",
  NextPageToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
