% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{welfare}
\alias{welfare}
\title{Issue Framing and Support for Welfare Reform}
\format{
A data frame with 213 rows and 15 columns: \describe{
  \item{gender1}{Gender. 0: Female; 1: Male.}
  \item{educ1}{Level of education.
    1: the municipal primary and lower secondary school before ninth form;
    2: the municipal primary and lower secondary school after ninth or tenth form;
    3: Basic schooling; 4: Vocational education;
    5: Higher preparatory examination course student
    6: Upper secondary school student; 7: Higher commercial examination student
    8: Higher technical examination student; 9: Short-term further education;
    10: Medium-term further education; 11: Long-term further education;
    12: Foreign education; 13: Else.}
  \item{polint1}{Political interest, measured on a 0-4 scale.}
  \item{ideo1}{Ideological self-placement on a 1-8 scale. A larger value denotes a more
    right-wing position.}
  \item{know1}{Political knowledge. 1: low; 2: medium; 3: high.}
  \item{value1}{Extremity of political values. 0: moderate. 1: extreme.}
  \item{ttt}{Treatment assignment. Whether the respondent read a newspaper article that highlighted
    the positive effect of welfare reform on job creation (1) versus one emphasizing its negative
    effect on the poor (0).}
  \item{W1}{The degree to which the respondent attributes welfare recipiency to internal factors,
    measured on a 0-1 scale.}
  \item{W2}{The degree to which the respondent attributes welfare recipiency to external factors,
    measured on a 0-1 scale.}
  \item{M1}{How important the respondent thinks that there should always be an incentive for
    people to take a job instead of receiving welfare benefits, measured on a 0-1 scale.}
  \item{M2}{How important the respondent thinks that nobody should live in poverty, measured on
    a 0-1 scale.}
  \item{M3}{How important the respondent thinks that government expenditures on welfare
    benefits should not be too expensive, measured on a 0-1 scale.}
  \item{M4}{How important the respondent thinks that no defrauder should receive welfare benefits,
    measured on a 0-1 scale.}
  \item{M5}{How important the respondent thinks that the unemployed should have benefit rates
    making it possible to maintain a decent standard of living conditions, measured on a 0-1 scale.}
  \item{Y}{Support for the proposed welfare reform, measured on a seven-point scale.}
  }
}
\usage{
welfare
}
\description{
A dataset of 213 Danish students containing variables on gender, education, political interest,
  ideology, political knowledge, extremity of political values, treatment assignment (job/poor frame),
  beliefs about why some people receive welfare benefits, perceived importance of different
  considerations related to welfare policy, and support for a proposed welfare reform (Slothuus 2008; Imai and
  Yamamoto 2013).
}
\references{
Slothuus, Rune. 2008. "More than Weighting Cognitive Importance: A Dual-process Model of Issue
  Framing Effects." Political Psychology 29(1):1-28.

Imai, Kosuke and Teppei Yamamoto. 2013. "Identification and Sensitivity Analysis for Multiple
  Causal Mechanisms: Revisiting Evidence from Framing Experiments." Political Analysis 21(2):141-171.
}
\keyword{datasets}
