% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/counties.R
\name{pal.map}
\alias{pal.map}
\title{Show a palette using a map of U.S. counties}
\usage{
pal.map(pal = brewer.paired, n = 12, main = "")
}
\arguments{
\item{pal}{A palette function or a vector of colors.}

\item{n}{Number of colors to return.}

\item{main}{Main title}
}
\value{
None
}
\description{
What to look for:
}
\details{
1. Are regions distinct?

2. Are outliers within each region distinct?

Display a palette on a choropleth map similar to ColorBrewer.

Broad bands of color are easy to distinguish.
Does the palette allow visibility of outlier counties in the larger regions?
Does the palette allow identification of colors when the
pattern is more complex (as in the lower left corner of the map)?

Notes. The map shown by the ColorBrewer website is an SVG here
https://github.com/axismaps/colorbrewer/tree/master/map/map.svg
which contains the class identifier for each polygon, for 3 to 12 classes.
Unfortunately, the polygons have no other identification (e.g. FIPS, county name).
We used the identify.map function in R to manually define the classes
similar to the 12-class map of ColorBewer.
This proved to be too tedious to do more than once, so our maps of 1-11 classes were
created by combining classes from the 12-class map.  The ColorBrewer website
sometimes used this strategy to combine classes, but not always.
The 'outlier' counties and 'random region' in this version are very similar to
the 12-region map of ColorBrewer, but there are a few differences, mostly
intentional.
Also, the map projection used here is different from ColorBrewer.
}
\examples{

pal.map(brewer.paired, main="brewer.paired")
pal.map(parula)

\dontrun{
for(i in 3:12){
  pal.map(n=i, main=i)
}
}

}
\references{
http://www.personal.psu.edu/cab38/Pub_scans/Brewer_pubs.html
Map based on www.ColorBrewer.org, by Cynthia A. Brewer, Penn State.
}
\author{
Kevin Wright
}
