% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvm.R
\name{dotcvm}
\alias{dotcvm}
\title{Calculate 3D covariance matrix using unscaled congruence coefficient.  Skips any missing values in computation of covariance matrix}
\usage{
dotcvm(A)
}
\arguments{
\item{A}{An N x 3 x M array where N is the number of landmarks, 3 is the number of dimensions, and M is the number of specimens.}
}
\value{
N x N covariance matrix
}
\description{
Calculate 3D covariance matrix using unscaled congruence coefficient.  
  Skips any missing values in computation of covariance matrix
}
\details{
This function does not guarantee that the returned matrix is  
 positive definite. If the covariance matrix is not positive definite 
 a warning is given and the matrix can be bent to create the closest
 positive definite matrix with \code{as.matrix(Matrix::nearPD(mat)$mat)}.
}
\examples{
A <- array(rnorm(4 * 2 * 3), dim = c(2, 3, 4)) 
A.cvm <- dotcvm(A)
}

