% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PgR6MS.R
\name{PgR6MS}
\alias{PgR6MS}
\title{PgR6 class with Methods and Sequences.}
\description{
PgR6 with Methods and Sequences. Final users should use \code{\link{pagoo}}
instead of this, since is more easy to understand.
 Inherits: \code{\link[pagoo]{PgR6M}}
}
\section{Super classes}{
\code{\link[pagoo:PgR6]{pagoo::PgR6}} -> \code{\link[pagoo:PgR6M]{pagoo::PgR6M}} -> \code{PgR6MS}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{sequences}}{A \code{\link[Biostrings:XStringSetList-class]{DNAStringSetList}} with the
set of sequences grouped by cluster. Each group is accessible as were a list. All
\code{Biostrings} methods are available.}

\item{\code{core_sequences}}{Like \code{$sequences}, but only showing core
sequences.}

\item{\code{cloud_sequences}}{Like \code{$sequences}, but only showing cloud
sequences as defined above.}

\item{\code{shell_sequences}}{Like \code{$sequences}, but only showing shell
sequences, as defined above.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PgR6MS-new}{\code{PgR6MS$new()}}
\item \href{#method-PgR6MS-core_seqs_4_phylo}{\code{PgR6MS$core_seqs_4_phylo()}}
\item \href{#method-PgR6MS-clone}{\code{PgR6MS$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="add_metadata"><a href='../../pagoo/html/PgR6.html#method-PgR6-add_metadata'><code>pagoo::PgR6$add_metadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="drop"><a href='../../pagoo/html/PgR6.html#method-PgR6-drop'><code>pagoo::PgR6$drop()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="recover"><a href='../../pagoo/html/PgR6.html#method-PgR6-recover'><code>pagoo::PgR6$recover()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="save_pangenomeRDS"><a href='../../pagoo/html/PgR6.html#method-PgR6-save_pangenomeRDS'><code>pagoo::PgR6$save_pangenomeRDS()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6" data-id="write_pangenome"><a href='../../pagoo/html/PgR6.html#method-PgR6-write_pangenome'><code>pagoo::PgR6$write_pangenome()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="cg_exp_decay_fit"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-cg_exp_decay_fit'><code>pagoo::PgR6M$cg_exp_decay_fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="dist"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-dist'><code>pagoo::PgR6M$dist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="gg_barplot"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-gg_barplot'><code>pagoo::PgR6M$gg_barplot()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="gg_binmap"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-gg_binmap'><code>pagoo::PgR6M$gg_binmap()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="gg_curves"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-gg_curves'><code>pagoo::PgR6M$gg_curves()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="gg_dist"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-gg_dist'><code>pagoo::PgR6M$gg_dist()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="gg_pca"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-gg_pca'><code>pagoo::PgR6M$gg_pca()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="gg_pie"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-gg_pie'><code>pagoo::PgR6M$gg_pie()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="pan_pca"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-pan_pca'><code>pagoo::PgR6M$pan_pca()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="pg_power_law_fit"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-pg_power_law_fit'><code>pagoo::PgR6M$pg_power_law_fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="rarefact"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-rarefact'><code>pagoo::PgR6M$rarefact()</code></a></span></li>
<li><span class="pkg-link" data-pkg="pagoo" data-topic="PgR6M" data-id="runShinyApp"><a href='../../pagoo/html/PgR6M.html#method-PgR6M-runShinyApp'><code>pagoo::PgR6M$runShinyApp()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PgR6MS-new"></a>}}
\if{latex}{\out{\hypertarget{method-PgR6MS-new}{}}}
\subsection{Method \code{new()}}{
Create a \code{PgR6MS} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6MS$new(
  data,
  org_meta,
  cluster_meta,
  core_level = 95,
  sep = "__",
  DF,
  group_meta,
  sequences,
  verbose = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{A \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{DataFrame}} containing at least the
following columns: \code{gene} (gene name), \code{org} (organism name to which the gene belongs to),
and \code{cluster} (group of orthologous to which the gene belongs to). More columns can be added as metadata
for each gene.}

\item{\code{org_meta}}{(optional) A \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{DataFrame}}
containing additional metadata for organisms. This \code{data.frame} must have a column named "org" with
valid organisms names (that is, they should match with those provided in \code{data}, column \code{org}), and
additional columns will be used as metadata. Each row should correspond to each organism.}

\item{\code{cluster_meta}}{(optional) A \code{data.frame} or \code{\link[S4Vectors:DataFrame-class]{DataFrame}}
containing additional metadata for clusters. This \code{data.frame} must have a column named "cluster" with
valid organisms names (that is, they should match with those provided in \code{data}, column \code{cluster}), and
additional columns will be used as metadata. Each row should correspond to each cluster.}

\item{\code{core_level}}{The initial core_level (that's the percentage of organisms a core cluster must be in to be
considered as part of the core genome). Must be a number between 100 and 85, (default: 95). You can change it
later by using the \code{$core_level} field once the object was created.}

\item{\code{sep}}{A separator. By default is '__'(two underscores). It will be used to
create a unique \code{gid} (gene identifier) for each gene. \code{gid}s are created by pasting
\code{org} to \code{gene}, separated by \code{sep}.}

\item{\code{DF}}{Deprecated. Use \code{data} instead.}

\item{\code{group_meta}}{Deprecated. Use \code{cluster_meta} instead.}

\item{\code{sequences}}{Can accept: 1) a named \code{list} of named \code{character} vector. Name of list
are names of organisms, names of character vector are gene names; or 2) a named \code{list} of \code{\link[Biostrings:XStringSet-class]{DNAStringSetList}}
objects (same requirements as (1), but with BStringSet names as gene names); or 3) a \code{\link[Biostrings:XStringSetList-class]{DNAStringSetList}}
(same requirements as (2) but \code{DNAStringSetList} names are organisms names).}

\item{\code{verbose}}{\code{logical}. Whether to display progress messages when loading class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An R6 object of class PgR6MS. It contains basic fields and methods for analyzing a pangenome. It also
contains additional statistical methods for analyze it, methods to make basic exploratory plots, and methods
for sequence manipulation.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PgR6MS-core_seqs_4_phylo"></a>}}
\if{latex}{\out{\hypertarget{method-PgR6MS-core_seqs_4_phylo}{}}}
\subsection{Method \code{core_seqs_4_phylo()}}{
A field for obtaining core gene sequences is available (see below), but for creating a phylogeny with this
sets is useful to: 1) have the possibility of extracting just one sequence of each organism on each cluster, in
case paralogues are present, and 2) filling gaps with empty sequences in case the core_level was set below 100\%,
allowing more genes (some not in 100\% of organisms) to be incorporated to the phylogeny. That is the purpose of
this special function.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6MS$core_seqs_4_phylo(max_per_org = 1, fill = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{max_per_org}}{Maximum number of sequences of each organism to be taken from each cluster.}

\item{\code{fill}}{\code{logical}. If fill \code{DNAStringSet} with empty \code{DNAString} in cases where
\code{core_level} is set below 100\%, and some clusters with missing organisms are also considered.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{DNAStringSetList} with core genes. Order of organisms on each cluster is conserved, so it is easier
to concatenate them into a super-gene suitable for phylogenetic inference.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PgR6MS-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PgR6MS-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PgR6MS$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
