% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{prep_emission_intensity}
\alias{prep_emission_intensity}
\title{Prepare data for a emission intensity plot}
\usage{
prep_emission_intensity(data, convert_label = identity, span_5yr = FALSE)
}
\arguments{
\item{data}{A data frame. Requirements:
\itemize{
\item The structure must be like \link[r2dii.plot]{sda}.
\item The column \code{sector} must have a single value (e.g. "cement").
\item (Optional) If present, the column \code{label} is used for data labels.
}}

\item{convert_label}{A symbol. The unquoted name of a function to apply to
y-axis labels. For example:
\itemize{
\item To convert labels to uppercase use \code{convert_label = toupper}.
\item To get the default behavior of \code{qplot_emission_intensity()} use
\code{convert_label = to_title}.
}}

\item{span_5yr}{Logical. Use \code{TRUE} to restrict the time span to 5 years from
the start year (the default behavior of \code{qplot_emission_intensity()}), or use
\code{FALSE} to impose no restriction.}
}
\value{
A data-frame ready to be plotted using \code{plot_emission_intensity()}.
}
\description{
Prepare data for a emission intensity plot
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(sda, sector == "cement" & region == "global")
prep_emission_intensity(data)
}
\seealso{
Other plotting functions: 
\code{\link{plot_emission_intensity}()},
\code{\link{plot_techmix}()},
\code{\link{plot_trajectory}()},
\code{\link{prep_techmix}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_emission_intensity}()},
\code{\link{qplot_techmix}()},
\code{\link{qplot_trajectory}()},
\code{\link{recode_metric_techmix}()},
\code{\link{recode_metric_trajectory}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{scale_fill_r2dii_tech}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
