% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cranDownloads.R
\name{plot.cranDownloads}
\alias{plot.cranDownloads}
\title{Plot method for cranDownloads().}
\usage{
\method{plot}{cranDownloads}(x, graphics = "auto", points = "auto",
  log.count = FALSE, smooth = FALSE, se = FALSE, f = 1/3,
  package.version = FALSE, r.version = FALSE, population.plot = FALSE,
  multi.plot = FALSE, same.xy = TRUE, legend.loc = "topleft",
  dev.mode = FALSE, ...)
}
\arguments{
\item{x}{object.}

\item{graphics}{Character. "auto", "base" or "ggplot2".}

\item{points}{Character of Logical. Plot points. "auto", TRUE, FALSE.}

\item{log.count}{Logical. Logarithm of package downloads.}

\item{smooth}{Logical. Add smoother.}

\item{se}{Logical. Works only with graphics = "ggplot2".}

\item{f}{Numeric. stats::lowess() smoother window. For use with graphics = "base" only.}

\item{package.version}{Logical. Add latest package release dates.}

\item{r.version}{Logical. Add R release dates.}

\item{population.plot}{Logical. Plot population plot.}

\item{multi.plot}{Logical.}

\item{same.xy}{Logical. Use same scale for multiple packages when graphics = "base".}

\item{legend.loc}{Character.}

\item{dev.mode}{Logical. Use packageHistory0() to scrape CRAN.}

\item{...}{Additional plotting parameters.}
}
\value{
A base R or ggplot2 plot.
}
\description{
Plot method for cranDownloads().
}
\examples{
\donttest{
plot(cranDownloads(packages = c("Rcpp", "rlang", "data.table")))
plot(cranDownloads(packages = c("Rcpp", "rlang", "data.table"), when = "last-month"))
plot(cranDownloads(packages = "R", from = "2020-01-01", to = "2020-01-01"))
plot(cranDownloads(packages = "R", from = 2020))
}
}
