% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3c_cost_analysis_functions.R
\name{microcosting_tablets_patches}
\alias{microcosting_tablets_patches}
\title{Function to estimate the cost of tablets and patches taken (from IPD)}
\usage{
microcosting_tablets_patches(
  form,
  ind_part_data,
  name_med,
  dose_med,
  dose_unit,
  no_taken,
  freq_taken,
  basis_time,
  unit_cost_data,
  unit_cost_column,
  cost_calculated_in,
  strength_expressed_in,
  list_period_timepoint = NULL,
  list_of_code_names = NULL,
  list_of_code_freq = NULL,
  list_of_code_dose_unit = NULL,
  equiv_dose = NULL
)
}
\arguments{
\item{form}{the form of medication either tablet or patch}

\item{ind_part_data}{IPD}

\item{name_med}{name of medication}

\item{dose_med}{dose of medication}

\item{dose_unit}{unit of strength}

\item{no_taken}{how many taken}

\item{freq_taken}{frequency of medication}

\item{basis_time}{basis for time}

\item{unit_cost_data}{unit costs data}

\item{unit_cost_column}{column name of unit cost in unit_cost_data}

\item{cost_calculated_in}{column name of unit where the cost is calculated}

\item{strength_expressed_in}{column name of strength in the unit cost data}

\item{list_period_timepoint}{list of time period at each timepoint if coded}

\item{list_of_code_names}{if names is coded, give the code:name pairs}

\item{list_of_code_freq}{if frequency is coded, give the
code:frequency pairs}

\item{list_of_code_dose_unit}{if unit is coded, give the code:unit pairs}

\item{equiv_dose}{if cost per equivalent doses are to be calculates,
provide equiv_dose}
}
\value{
the calculated cost of tablets along with original data
}
\description{
Function to estimate the cost of tablets and patches taken (from IPD)
}
\details{
Assumes individual level data has name of medication, dose, dose unit,
number taken, frequency taken, and basis time
Assumes unit cost data contains the name of medication, form/type,
strength, unit of strength (or the unit in which the cost calculated),
preparation, unit cost, size and size unit
(in which name, forms, size, size unit, and preparation  are not passed on)
}
\examples{
freq_desc <- c(
  "Once a day", "Twice a day", "Three times a day",
  "Four times a day", "Five times a day", "Six times a day",
  "Seven times a day", "Eight times a day", "Nine times a day",
  "Ten times a day", "Once every 2 days", "Once every 3 days",
  "Once every 4 days", "Once every 5 days", "Once every 6 days",
  "Once a week", "Twice a week", "Thrice a week", "Four times a week"
)
codes <- c(seq(1:19))
this_list <- list(freq_desc, codes)
med_costs_file <- system.file("extdata", "average_unit_costs_med.csv",
package = "packDAMipd")
data_file <- system.file("extdata", "resource_use_t.csv",
package = "packDAMipd")
ind_part_data <- load_trial_data(data_file)
med_costs <- load_trial_data(med_costs_file)
res <- microcosting_tablets_patches("tablets",
  ind_part_data, "Name", "tab_dosage", "tab_dosage_unit", "tab_no_taken",
  "tab_frequency", "day", med_costs, "UnitCost",
  "StrengthUnit", "Strength", list(c("4 weeks", "1 week"), c(1, 2)),
  list(c("Buprenorphine", "Morphine"), c(1, 2)), this_list,
  list(c("mcg", "mg", "gm"), c(1, 2, 3)), "tab_equiv_dose"
)
}
