% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IVE.R
\name{IVE}
\alias{IVE}
\title{The (S)IVE estimator.}
\usage{
IVE(eta, datalist, ps, t0, smooth = TRUE)
}
\arguments{
\item{eta}{The parameters of the regime.}

\item{datalist}{A list used to calculate the (S)IVE estimator including treatment named \code{a}, observed time named \code{obs.t}, censoring indicator (0, censored) named \code{delta}, and baseline covariates used to assign treatment named \code{l}.}

\item{ps}{A list including the probability of receiving instrument given baseline covariates named \code{fzl} and the difference between fal1 and fal0 named \code{deltal}, where fal0 denotes the probability of receiving treatment given baseline covariates and instrument equaling 0, and fal1 denotes the probability of receiving treatment given baseline covariates and instrument equaling 1. \code{\link[otrKM]{Fps.IVE}} can produce \code{ps} by positing logistic model.}

\item{t0}{A predetermined time.}

\item{smooth}{A logic variable indicating wether a smoothed version should be used.}
}
\value{
Estimated potential survival probability given eta and t0.
}
\description{
Given a predetermined t0 and eta, calculate t0-year potential survival probability based on the (S)IVE estimator.
}
\details{
More details can be found in references.
}
\examples{
# load data
data(simulation)

# convert the data into a datalist
datalist=list(z=simulation$Instrument,a=simulation$Treatment,
              obs.t=simulation$Survival,delta=simulation$Status,
              l=cbind(simulation$Covariate1,simulation$Covariate2))

# calculate ps and prep
ps=Fps.IVE(datalist)

# predetermined eta
t0=5
eta=c(1,2,3)

IVE(eta, datalist, ps, t0, smooth=TRUE)
}
\references{
{Xia, J., Zhan, Z., Zhang, J. (2022) An anti-confounding method for estimating optimal regime in a survival context using instrumental variable. Under Review.}
}
