% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwasRegional.R
\name{gwasRegional}
\alias{gwasRegional}
\title{Retrieve GWAS summary statistics for a genomic region.}
\usage{
gwasRegional(study_id, chromosome, start, end)
}
\arguments{
\item{study_id}{Character: Open Target Genetics generated ID for the GWAS study.}

\item{chromosome}{Character: Chromosome number as a string.}

\item{start}{Integer: Start position of the specified chromosome.}

\item{end}{Integer: End position of the specified chromosome.}
}
\value{
Returns a data table of variant information and p-values with the following columns:
\itemize{
  \item{\code{variant.id}:} \emph{Character vector}. Variant identifier.
  \item{\code{variant.chromosome}:} \emph{Character vector}. Chromosome of the variant.
  \item{\code{variant.position}:} \emph{Integer vector}. Position of the variant.
  \item{\code{pval}:} \emph{Numeric vector}. P-value.
}
}
\description{
For a given study ID and chromosomal region information, this function returns  data frame(tibble format) with all variants and their GWAS summary statistics.
}
\examples{
\dontrun{
result <- gwasRegional(study_id = "GCST90002357",
chromosome = "1", start = 153992685, end = 154155116)
}
}
