% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmchange.R
\name{osmchange_delete}
\alias{osmchange_delete}
\title{\code{osmchange} to delete existing OSM objects}
\usage{
osmchange_delete(x, delete_if_unused = FALSE, format = c("R", "osc", "xml"))
}
\arguments{
\item{x}{A \link{osmapi_objects} or \code{data.frame} with the columns \code{type} and \code{id} for the objects to delete. Other columns
will be ignored.}

\item{delete_if_unused}{If \code{TRUE}, the \verb{if-unused} attribute will be added (see details). Can be a vector of length
\code{nrow(x)}.}

\item{format}{Format of the output. Can be \code{"R"} (default), \code{"osc"} (\code{"xml"} is a synonym for \code{"osc"}).}
}
\value{
If \code{format = "R"}, returns a \code{osmapi_OsmChange} data frame with one OSM edition per row.
If \code{format = "osc"} or \code{format = "xml"}, returns a \link[xml2:oldclass]{xml2::xml_document} following the
\href{https://wiki.openstreetmap.org/wiki/OsmChange}{OsmChange format} that can be saved with \code{\link[xml2:write_xml]{xml2::write_xml()}} and
opened in other applications such as JOSM.

The results are  ready to send the editions to the servers with \code{\link[=osm_diff_upload_changeset]{osm_diff_upload_changeset()}}.
}
\description{
Prepare data to delete OSM objects.
}
\details{
If \verb{if-unused} attribute is present, then the delete operation(s) in this block are conditional and will only be
executed if the object to be deleted is not used by another object. Without the \verb{if-unused}, such a situation would
lead to an error, and the whole diff upload would fail. Setting the attribute will also cause deletions of already
deleted objects to not generate an error.
}
\examples{
\dontrun{
obj_id <- osmapi_objects(data.frame(
  type = c("way", "way", "relation", "node"),
  id = c("722379703", "629132242", "8387952", "4739010921")
))
osmchange_del <- osmchange_delete(obj_id)
}
}
\seealso{
Other OsmChange's functions: 
\code{\link{osm_diff_upload_changeset}()},
\code{\link{osm_download_changeset}()},
\code{\link{osmchange_create}()},
\code{\link{osmchange_modify}()}
}
\concept{OsmChange's functions}
