% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote.R
\name{orderly_pull_dependencies}
\alias{orderly_pull_dependencies}
\alias{orderly_pull_archive}
\alias{orderly_push_archive}
\title{Download dependent reports}
\usage{
orderly_pull_dependencies(
  name = NULL,
  root = NULL,
  locate = TRUE,
  remote = NULL,
  parameters = NULL,
  recursive = TRUE
)

orderly_pull_archive(
  name,
  id = "latest",
  root = NULL,
  locate = TRUE,
  remote = NULL,
  parameters = NULL,
  recursive = TRUE
)

orderly_push_archive(
  name,
  id = "latest",
  root = NULL,
  locate = TRUE,
  remote = NULL
)
}
\arguments{
\item{name}{Name of the report to download dependencies for.
Alternatively, the default of \code{NULL} is useful if you have
already set the working directory to be the source directory.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{remote}{Description of the location.  Typically this is a
character string indicating a remote specified in the
\code{remotes} block of your \code{orderly_config.yml}.  It is
also possible to pass in a directly created remote object (e.g.,
using \code{\link[=orderly_remote_path]{orderly_remote_path()}}, or one provided by
another package).  If left \code{NULL}, then the default remote
for this orderly repository is used - by default that is the
first listed remote.}

\item{parameters}{Parameters to pass through when doing dependency
resolution.  If you are using a query for \code{id} that
involves a parameter (e.g., \code{latest(parameter:x == p)}) you
will need to pass in the parameters here.  Similarly, if you are
pulling a report that uses query dependencies that reference
parameters you need to pass them here (the same parameter set
will be passed through to all dependencies).}

\item{recursive}{Logical, indicating if all dependencies of a
report should also be pulled. Setting this to \code{FALSE} only
the direct reports, along with metadata for the dependencies;
this will be potentially much faster, but leaves your archive in
a more fragile state.}

\item{id}{The identifier (for \code{orderly_pull_archive}).  The default is
to use the latest report.}
}
\value{
No return value, these functions are called only for their
side effects
}
\description{
Download dependent reports from an orderly remote.  This can only
be used if the \code{orderly_config.yml} lists a remote.  This
allows for a centralised workflow where a central orderly store
exists and holds the canonical copies of reports, from which
versions can be downloaded into local stores.
}
\details{
The \code{orderly_pull_archive} function pulls report directly
(without it being a dependent report).

After setting your username up you can run
\code{orderly_pull_dependencies("reportname")} to pull the
\emph{dependencies} of \code{"reportname"} down so that
\code{"reportname"} can be run, or you can run
\code{orderly_pull_archive("reportname")} to pull a copy of
\code{"reportname"} that has been run on the remote server.

Pulling an archive report from a remote also pulls its
dependencies (recursively), and adds all of these to the local
database.  This may require migrating old orderly archives
(\code{\link[=orderly_migrate]{orderly_migrate()}}).  Note that this migration will
likely fail for remote orderly versions older than 0.6.8 because
the migration needs to read data files on disk that are not
included in the downloaded archive in order to collect all the
information required for the database.  In this case, ask the
administrator of the remote orderly archive to migrate their
archive, and then re-pull.

Pushing an archive is possible only if the remote supports it.
Currently this is supported by \code{\link[=orderly_remote_path]{orderly_remote_path()}}
remotes, though not by orderlyweb remotes.  There is no control
over what will \emph{accept} a push at this point, nor any check
that what you've pushed is "good" except that it exists in your
archive.  As with pulling an archive, pushes are recursive with
respect to dependencies.  The configuration interface here will
likely change a little over time.
}
\examples{
# Suppose we have a "remote" orderly repository at some path.
# This might be read-only for you in practice and available via a
# network filesystem or a dropbox folder synced to your computer.
# We'll populate this with a pair of reports:
path_remote <- orderly::orderly_example("demo")
id <- orderly::orderly_run("other", list(nmin = 0),
                           root = path_remote, echo = FALSE)
orderly::orderly_commit(id, root = path_remote)
id <- orderly::orderly_run("use_dependency",
                           root = path_remote, echo = FALSE)
orderly::orderly_commit(id, root = path_remote)

# We'll create a an object to interact with this remote using
# orderly_remote_path.
remote <- orderly::orderly_remote_path(path_remote)

# We can use this object directly
remote$list_reports()
remote$list_versions("other")

# More typically one will interact with the functions
# orderly_pull_archive and orderly_pull_dependencies.

# Now, suppose that you have your "local" copy of this; it shares
# the same source (ordinarily these would both be under version
# control with git):
path_local <- orderly::orderly_example("demo")

# If we wanted to run the report "use_dependency" we need to have
# a copy of the report "other", on which it depends:
try(orderly::orderly_run("use_dependency", root = path_local))

# We can "pull" dependencies of a report before running
orderly::orderly_pull_dependencies("use_dependency", remote = remote,
                                   root = path_local)

# Now we can run the report because we have a local copy of the
# dependency:
orderly::orderly_run("use_dependency", root = path_local)

# We can also directly pull previously run reports:
orderly::orderly_pull_archive("use_dependency", id, remote = remote,
                              root = path_local)
orderly::orderly_list_archive(root = path_local)
}
\seealso{
\code{\link[=orderly_remote_path]{orderly_remote_path()}}, which implements the
remote interface for orderly repositories at a local path.  See
also \href{https://github.com/vimc/orderly-web}{OrderlyWeb} for a
system for hosting orderly repositories over an HTTP API.
\code{vignette("remote", package = "orderly")} describes the
remote system in more detail.
}
