% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{pp_check_ordbeta}
\alias{pp_check_ordbeta}
\title{Accurate Posterior Predictive Plots for Ordbetareg Models}
\usage{
pp_check_ordbeta(
  model = NULL,
  type = "both",
  ndraws = 10,
  cores = NULL,
  group = NULL,
  new_theme = NULL,
  outcome_label = NULL,
  animate = FALSE,
  reverse_bounds = TRUE
)
}
\arguments{
\item{model}{A fitted \link{ordbetareg} model.}

\item{type}{Default is "both" for creating both a
discrete (bar) and continuous (density) plot. Can also be
"discrete" for only the bar plot for discrete values (0/1) or
"continuous" for continuous values (density plot).}

\item{ndraws}{Number of posterior draws to use to calculate estimates and show in plot.
Defaults to 10.}

\item{cores}{Number of cores to use to produce posterior predictive distribution. Defaults to NULL or 1 core.}

\item{group}{A factor variable of the same number of
rows as the data that is used to broduce grouped
(faceted) plots of the posterior distribution.}

\item{new_theme}{Any additional themes to be added to ggplot2 (default is NULL).}

\item{outcome_label}{A character value that will replace the name of the outcome in the plot
(default is the name of the response variable in the data frame).}

\item{animate}{Whether to animate each posterior draw for continuous
distributions (defaults to FALSE).}

\item{reverse_bounds}{Whether to plot data using the original bounds in the data
(i.e. not 0 and 1).}
}
\value{
If "both", prints both plots and returns a list of both plots as
\code{ggplot2} objects. Otherwise, prints and returnst the specific plot
as a \code{ggplot2} object.
}
\description{
The standard \link[brms:pp_check.brmsfit]{brms::pp_check} plot available via \code{brms}
is not accurate for ordbetareg models because an
ordered beta regression has both continuous and discrete
components. This function implements a bar plot and a density
plot for the continuous and discrete elements separately,
and will return accurate posterior predictive plots
relative to the data.
}
\examples{

# need a fitted ordbetareg model

data("ord_fit_mean")

out_plots <- pp_check_ordbeta(ord_fit_mean)

# view discrete bar plot

out_plots$discrete

# view continuous density plot

out_plots$continuous

# change title using ggplot2 ggtitle function

out_plots$discrete + ggplot2::ggtitle("New title")

}
