% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{setColWidths}
\alias{setColWidths}
\title{Set worksheet column widths}
\usage{
setColWidths(wb, sheet, cols, widths = 8.43, hidden = rep(FALSE,
  length(cols)), ignoreMergedCells = FALSE)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{cols}{Indices of cols to set width}

\item{widths}{widths to set cols to specified in Excel column width units or "auto" for automatic sizing. The widths argument is
recycled to the length of cols.}

\item{hidden}{Logical vector. If TRUE the column is hidden.}

\item{ignoreMergedCells}{Ignore any cells that have been merged with other cells in the calculation of "auto" column widths.}
}
\description{
Set worksheet column widths to specific width or "auto".
}
\details{
The global min and max column width for "auto" columns is set by (default values show):
\itemize{
  \item{options("openxlsx.minWidth" = 3)}
  \item{options("openxlsx.maxWidth" = 250)} ## This is the maximum width allowed in Excel
}

NOTE: The calculation of column widths can be slow for large worksheets.
}
\examples{
## Create a new workbook
wb <- createWorkbook()

## Add a worksheet
addWorksheet(wb, "Sheet 1") 


## set col widths
setColWidths(wb, 1, cols = c(1,4,6,7,9), widths = c(16,15,12,18,33))

## auto columns
addWorksheet(wb, "Sheet 2")
writeData(wb, sheet = 2, x = iris)
setColWidths(wb, sheet = 2, cols = 1:5, widths = "auto")
  
## Save workbook
saveWorkbook(wb, "setColWidthsExample.xlsx", overwrite = TRUE)
}
\seealso{
\code{\link{removeColWidths}}
}
\author{
Alexander Walker
}
