% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{createStyle}
\alias{createStyle}
\title{Create a cell style}
\usage{
createStyle(fontName = NULL, fontSize = NULL, fontColour = NULL,
  numFmt = "GENERAL", border = NULL,
  borderColour = getOption("openxlsx.borderColour", "black"),
  borderStyle = getOption("openxlsx.borderStyle", "thin"), bgFill = NULL,
  fgFill = NULL, halign = NULL, valign = NULL, textDecoration = NULL,
  wrapText = FALSE, textRotation = NULL, indent = NULL)
}
\arguments{
\item{fontName}{A name of a font. Note the font name is not validated. If fontName is NULL,
the workbook base font is used. (Defaults to Calibri)}

\item{fontSize}{Font size. A numeric greater than 0.
If fontSize is NULL, the workbook base font size is used. (Defaults to 11)}

\item{fontColour}{Colour of text in cell.  A valid hex colour beginning with "#"
or one of colours(). If fontColour is NULL, the workbook base font colours is used.
(Defaults to black)}

\item{numFmt}{Cell formatting
\itemize{
  \item{\bold{GENERAL}}
  \item{\bold{NUMBER}}
  \item{\bold{CURRENCY}}
  \item{\bold{ACCOUNTING}}
  \item{\bold{DATE}}
  \item{\bold{LONGDATE}}
  \item{\bold{TIME}}
  \item{\bold{PERCENTAGE}}
  \item{\bold{FRACTION}}
  \item{\bold{SCIENTIFIC}}
  \item{\bold{TEXT}}
  \item{\bold{COMMA}{  for comma seperated thousands}}
  \item{For date/datetime styling a combination of d, m, y and punctuation marks}
  \item{For numeric rouding use "0.00" with the preferred number of decimal places}
}}

\item{border}{Cell border 
(Any combination of "Top", "Bottom", "Left", "Right" in any order).
\itemize{
   \item{\bold{Top}}{ Top border}
   \item{\bold{Bottom}}{ Bottom border}
   \item{\bold{Left}}{ Left border}
   \item{\bold{Right}}{ Right border}
   \item{\bold{TopBottom}}{ Top and bottom border}
   \item{\bold{LeftRight}}{ Left and right border}
   \item{\bold{TopLeftRight}}{ Top and Left border}
   \item{\bold{TopBottomLeftRight}}{ All borders}
  }}

\item{borderColour}{Colour of cell border.
A valid colour (belonging to colours()) or a valid hex colour beginning with "#"}

\item{borderStyle}{Border line style
\itemize{
   \item{\bold{none}}{ No Border}
   \item{\bold{thin}}{ thin border}
   \item{\bold{medium}}{ medium border}
   \item{\bold{dashed}}{ dashed border}
   \item{\bold{dotted}}{ dotted border}
   \item{\bold{thick}}{ thick border}
   \item{\bold{double}}{ double line border}
   \item{\bold{hair}}{ Hairline border}
   \item{\bold{mediumDashed}}{ medium weight dashed border}
   \item{\bold{dashDot}}{ dash-dot border}
   \item{\bold{mediumDashDot}}{ medium weight dash-dot border}
   \item{\bold{dashDotDot}}{ dash-dot-dot border}
   \item{\bold{mediumDashDotDot}}{ medium weight dash-dot-dot border}
   \item{\bold{slantDashDot}}{ slanted dash-dot border}
  }}

\item{bgFill}{Cell background fill colour.
A valid colour (belonging to colours()) or a valid hex colour beginning with "#". 
--  Use for conditional formatting styles only.}

\item{fgFill}{Cell foreground fill colour.
A valid colour (belonging to colours()) or a valid hex colour beginning with "#"}

\item{halign}{Horizontal alignment of cell contents
\itemize{
   \item{\bold{left}}{ Left horizontal align cell contents}
   \item{\bold{right}}{ Right horizontal align cell contents}
   \item{\bold{center}}{ Center horizontal align cell contents}
  }}

\item{valign}{A name
Vertical alignment of cell contents
\itemize{
   \item{\bold{top}}{ Top vertical align cell contents}
   \item{\bold{center}}{ Center vertical align cell contents}
   \item{\bold{bottom}}{ Bottom vertical align cell contents}
  }}

\item{textDecoration}{Text styling.
\itemize{
   \item{\bold{bold}}{ Bold cell contents}
   \item{\bold{strikeout}}{ Strikeout cell contents}
   \item{\bold{italic}}{ Italicise cell contents}
   \item{\bold{underline}}{ Underline cell contents}
   \item{\bold{underline2}}{ Double underline cell contents}
  }}

\item{wrapText}{Logical. If \code{TRUE} cell contents will wrap to fit in column.}

\item{textRotation}{Rotation of text in degrees. 255 for vertial text.}

\item{indent}{Horizontal indentation of cell contents.}
}
\value{
A style object
}
\description{
Create a new style to apply to worksheet cells
}
\examples{
## See package vignettes for further examples

## Modify default values of border colour and border line style
options("openxlsx.borderColour" = "#4F80BD")
options("openxlsx.borderStyle" = "thin")

## Size 18 Arial, Bold, left horz. aligned, fill colour #1A33CC, all borders,
style <- createStyle(fontSize = 18, fontName = "Arial",
  textDecoration = "bold", halign = "left", fgFill = "#1A33CC", border= "TopBottomLeftRight")

## Red, size 24, Bold, italic, underline, center aligned Font, bottom border
style <- createStyle(fontSize = 24, fontColour = rgb(1,0,0),
   textDecoration = c("bold", "italic", "underline"), 
   halign = "center", valign = "center", border = "Bottom")
 
# borderColour is recycled for each border or all colours can be supplied

# colour is recycled 3 times for "Top", "Bottom" & "Right" sides.
createStyle(border = "TopBottomRight", borderColour = "red") 

# supply all colours
createStyle(border = "TopBottomLeft", borderColour = c("red","yellow", "green"))
}
\author{
Alexander Walker
}
\seealso{
\code{\link{addStyle}}
}

