% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rand_pseudo_bytes}
\alias{rand_bytes}
\alias{rand_pseudo_bytes}
\title{Generate random bytes with OpenSSL}
\usage{
rand_pseudo_bytes(n = 1)

rand_bytes(n = 1)
}
\arguments{
\item{n}{number of random bytes to generate}
}
\description{
Generate random bytes with OpenSSL
}
\examples{
rnd <- rand_bytes(10)
as.numeric(rnd)
as.character(rnd)
as.logical(rawToBits(rnd))

# numbers range from 0 to 255
rnd <- rand_bytes(100000)
hist(as.numeric(rnd), breaks=-1:255)
}
\references{
OpenSSL manual: \url{https://www.openssl.org/docs/crypto/RAND_bytes.html}
}

