% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-stent30.R
\docType{data}
\name{stent30}
\alias{stent30}
\alias{stent365}
\title{Stents for the treatment of stroke}
\format{
A data frame with 451 observations on the following 2 variables.
\describe{
  \item{group}{a factor with levels \code{control} and \code{treatment}}
  \item{outcome}{a factor with levels \code{no event} and \code{stroke}}
  }
}
\source{
Chimowitz MI, Lynn MJ, Derdeyn CP, et al. 2011. Stenting versus
Aggressive Med- ical Therapy for Intracranial Arterial Stenosis. New England
Journal of Medicine 365:993- 1003.
\url{https://www.nejm.org/doi/full/10.1056/NEJMoa1105335}.
NY Times article reporting on the study: \url{https://www.nytimes.com/2011/09/08/health/research/08stent.html}.
}
\usage{
stent30
}
\description{
An experiment that studies effectiveness of stents in treating patients at
risk of stroke with some unexpected results. `stent30` represents
the results 30 days after stroke and `stent365` represents the results
365 days after stroke.
}
\examples{

# 30-day results
table(stent30)

# 365-day results
table(stent365)

}
\keyword{datasets}
