% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polar_percentileMap.R
\name{percentileMap}
\alias{percentileMap}
\title{Percentile roses on interactive leaflet maps}
\usage{
percentileMap(
  data,
  pollutant = NULL,
  percentile = c(25, 50, 75, 90, 95),
  latitude = NULL,
  longitude = NULL,
  control = NULL,
  popup = NULL,
  label = NULL,
  provider = "OpenStreetMap",
  cols = "turbo",
  alpha = 1,
  key = FALSE,
  draw.legend = TRUE,
  collapse.control = FALSE,
  d.icon = 200,
  d.fig = 3.5,
  type = deprecated(),
  ...
)
}
\arguments{
\item{data}{A data frame. The data frame must contain the data to plot the
directional analysis marker, which includes wind speed (\code{ws}), wind
direction (\code{wd}), and the column representing the concentration of a
pollutant. In addition, \code{data} must include a decimal latitude and
longitude.}

\item{pollutant}{The column name(s) of the pollutant(s) to plot. If multiple
pollutants are specified, they can be toggled between using a "layer
control" interface.}

\item{percentile}{The percentile value(s) to plot. Must be between 0–100. If
\code{percentile = NA} then only a mean line will be shown.}

\item{latitude, longitude}{The decimal latitude/longitude. If not provided,
will be automatically inferred from data by looking for a column named
"lat"/"latitude" or "lon"/"lng"/"long"/"longitude" (case-insensitively).}

\item{control}{Used for splitting the input data into different groups which
can be selected between using a "layer control" interface, passed to the
\code{type} argument of \code{\link[openair:cutData]{openair::cutData()}}. \code{control} cannot be used if
multiple \code{pollutant} columns have been provided.}

\item{popup}{Columns to be used as the HTML content for marker popups. Popups
may be useful to show information about the individual sites (e.g., site
names, codes, types, etc.). If a vector of column names are provided they
are passed to \code{\link[=buildPopup]{buildPopup()}} using its default values.}

\item{label}{Column to be used as the HTML content for hover-over labels.
Labels are useful for the same reasons as popups, though are typically
shorter.}

\item{provider}{The base map(s) to be used. See
\url{http://leaflet-extras.github.io/leaflet-providers/preview/} for a list of
all base maps that can be used. If multiple base maps are provided, they
can be toggled between using a "layer control" interface.}

\item{cols}{The colours used for plotting. See \code{\link[openair:openColours]{openair::openColours()}} for
more information.}

\item{alpha}{The alpha transparency to use for the plotting surface (a value
between 0 and 1 with zero being fully transparent and 1 fully opaque).}

\item{key}{Should a key for each marker be drawn? Default is \code{FALSE}.}

\item{draw.legend}{Should a shared legend be created at the side of the map?
Default is \code{TRUE}.}

\item{collapse.control}{Should the "layer control" interface be collapsed?
Defaults to \code{FALSE}.}

\item{d.icon}{The diameter of the plot on the map in pixels. This will affect
the size of the individual polar markers. Alternatively, a vector in the
form \code{c(width, height)} can be provided if a non-circular marker is
desired.}

\item{d.fig}{The diameter of the plots to be produced using \code{openair} in
inches. This will affect the resolution of the markers on the map.
Alternatively, a vector in the form \code{c(width, height)} can be provided if a
non-circular marker is desired.}

\item{type}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}. Different sites are now
automatically detected based on latitude and longitude. Please use \code{label}
and/or \code{popup} to label different sites.}

\item{...}{
  Arguments passed on to \code{\link[openair:percentileRose]{openair::percentileRose}}
  \describe{
    \item{\code{wd}}{Name of wind direction field.}
    \item{\code{smooth}}{Should the wind direction data be smoothed using a cyclic
spline?}
    \item{\code{method}}{When \code{method = "default"} the supplied percentiles by wind
direction are calculated. When \code{method = "cpf"} the conditional
probability function (CPF) is plotted and a single (usually high)
percentile level is supplied. The CPF is defined as CPF = my/ny, where my
is the number of samples in the wind sector y with mixing ratios greater
than the \emph{overall} percentile concentration, and ny is the total
number of samples in the same wind sector (see Ashbaugh et al., 1985).}
    \item{\code{angle}}{Default angle of \dQuote{spokes} is when \code{smooth = FALSE}.}
    \item{\code{mean}}{Show the mean by wind direction as a line?}
    \item{\code{mean.lty}}{Line type for mean line.}
    \item{\code{mean.lwd}}{Line width for mean line.}
    \item{\code{mean.col}}{Line colour for mean line.}
    \item{\code{fill}}{Should the percentile intervals be filled (default) or should
lines be drawn (\code{fill = FALSE}).}
    \item{\code{intervals}}{User-supplied intervals for the scale e.g. \code{intervals =
c(0, 10, 30, 50)}}
    \item{\code{angle.scale}}{Sometimes the placement of the scale may interfere with an
interesting feature. The user can therefore set \code{angle.scale} to
any value between 0 and 360 degrees to mitigate such problems. For
example \code{angle.scale = 45} will draw the scale heading in a NE
direction.}
    \item{\code{auto.text}}{Either \code{TRUE} (default) or \code{FALSE}. If \code{TRUE}
titles and axis labels will automatically try and format pollutant names
and units properly e.g.  by subscripting the `2' in NO2.}
    \item{\code{key.header}}{Adds additional text/labels to the scale key. For example,
passing the options \code{key.header = "header", key.footer = "footer1"}
adds addition text above and below the scale key. These arguments are
passed to \code{drawOpenKey} via \code{quickText}, applying the
\code{auto.text} argument, to handle formatting.}
    \item{\code{key.footer}}{see \code{key.footer}.}
    \item{\code{key.position}}{Location where the scale key is to plotted. Allowed
arguments currently include \code{"top"}, \code{"right"}, \code{"bottom"}
and \code{"left"}.}
  }}
}
\value{
A leaflet object.
}
\description{
\code{\link[=percentileMap]{percentileMap()}} creates a \code{leaflet} map using percentile roses as
markers. Any number of pollutants can be specified using the \code{pollutant}
argument, and multiple layers of markers can be added and toggled between
using \code{control}.
}
\examples{
\dontrun{
percentileMap(polar_data,
  pollutant = "nox",
  provider = "Stamen.Toner"
)
}
}
\seealso{
the original \code{\link[openair:percentileRose]{openair::percentileRose()}}

\code{\link[=percentileMapStatic]{percentileMapStatic()}} for the static \code{ggmap} equivalent of
\code{\link[=percentileMap]{percentileMap()}}

Other interactive directional analysis maps: 
\code{\link{annulusMap}()},
\code{\link{diffMap}()},
\code{\link{freqMap}()},
\code{\link{polarMap}()},
\code{\link{pollroseMap}()},
\code{\link{windroseMap}()}
}
\concept{interactive directional analysis maps}
