% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPolarMarkers.R
\name{addPolarMarkers}
\alias{addPolarMarkers}
\title{Add polar markers to leaflet map}
\usage{
addPolarMarkers(
  map,
  lng = NULL,
  lat = NULL,
  layerId = NULL,
  group = NULL,
  popup = NULL,
  label = NULL,
  data,
  fun = openair::polarPlot,
  pollutant,
  iconWidth = 200,
  iconHeight = 200,
  fig.width = 4,
  fig.height = 4,
  ...
)
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet:leaflet]{leaflet::leaflet()}}.}

\item{lng}{The decimal longitude.}

\item{lat}{The decimal latitude.}

\item{layerId}{The layer id.}

\item{group}{the name of the group the newly created layers should belong to
(for \code{\link[leaflet:remove]{leaflet::clearGroup()}} and \code{\link[leaflet:addLayersControl]{leaflet::addLayersControl()}} purposes).
Human-friendly group names are permitted–they need not be short,
identifier-style names. Any number of layers and even different types of
layers (e.g. markers and polygons) can share the same group name.}

\item{popup}{A column of \code{data} to be used as a popup.}

\item{label}{A column of \code{data} to be used as a label.}

\item{data}{A data frame. The data frame must contain the data to plot your
choice of openair directional analysis plot, which includes wind speed
(\code{ws}), wind direction (\code{wd}), and the column representing the
concentration of a pollutant. In addition, \code{data} must include a
decimal latitude and longitude.}

\item{fun}{An \code{openair} directional analysis plotting function.
Supported functions include \code{\link[openair:polarPlot]{openair::polarPlot()}} (the default),
\code{\link[openair:polarAnnulus]{openair::polarAnnulus()}}, \code{\link[openair:polarFreq]{openair::polarFreq()}},
\code{\link[openair:percentileRose]{openair::percentileRose()}}, \code{\link[openair:windRose]{openair::pollutionRose()}} and
\code{\link[openair:windRose]{openair::windRose()}}.}

\item{pollutant}{The name of the pollutant to be plot. Note that, if
\code{fun = openair::windRose}, you must set \code{pollutant = "ws"}.}

\item{iconWidth}{The actual width of the plot on the map in pixels.}

\item{iconHeight}{The actual height of the plot on the map in pixels.}

\item{fig.width}{The width of the plots to be produced in inches.}

\item{fig.height}{The height of the plots to be produced in inches.}

\item{...}{Other arguments for the plotting function (e.g. \code{period} for
\code{\link[openair:polarAnnulus]{openair::polarAnnulus()}}).}
}
\value{
A leaflet object.
}
\description{
This function is similar (but not identical to) the \code{\link[leaflet:map-layers]{leaflet::addMarkers()}}
and \code{\link[leaflet:map-layers]{leaflet::addCircleMarkers()}} functions in \code{leaflet}, which allows
users to add \code{openair} directional analysis plots to any leaflet map and
have more control over groups and layerIds than in "all-in-one" functions
like \code{\link[=polarMap]{polarMap()}}.
}
\examples{
\dontrun{
library(leaflet)
library(openair)

leaflet() \%>\%
  addTiles() \%>\%
  addPolarMarkers(
    data = polar_data,
    lat = "latitude",
    lng = "longitude",
    pollutant = "ws",
    fun = windRose,
    group = "Wind Rose"
  ) \%>\%
  addPolarMarkers(
    data = polar_data,
    lat = "latitude",
    lng = "longitude",
    pollutant = "nox",
    group = "Polar Plot"
  ) \%>\%
  addLayersControl(
    baseGroups = c("Wind Rose", "Polar Plot")
  )
}

}
