/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.Arrays;
import java.util.List;
import opennlp.maxent.MaxentModel;
import opennlp.tools.util.BeamSearchContextGenerator;
import opennlp.tools.util.Cache;
import opennlp.tools.util.ListHeap;
import opennlp.tools.util.Sequence;

public class BeamSearch {
    protected MaxentModel model;
    protected BeamSearchContextGenerator cg;
    protected int size;
    private static final Object[] EMPTY_ADDITIONAL_CONTEXT = new Object[0];
    private double[] probs;
    private Cache contextsCache;
    private static final int zeroLog = -100000;

    public BeamSearch(int size, BeamSearchContextGenerator cg, MaxentModel model) {
        this(size, cg, model, 0);
    }

    public BeamSearch(int size, BeamSearchContextGenerator cg, MaxentModel model, int cacheSize) {
        this.size = size;
        this.cg = cg;
        this.model = model;
        this.probs = new double[model.getNumOutcomes()];
        if (cacheSize > 0) {
            this.contextsCache = new Cache(cacheSize);
        }
    }

    public Sequence[] bestSequences(int numSequences, Object[] sequence, Object[] additionalContext) {
        return this.bestSequences(numSequences, sequence, additionalContext, -100000.0);
    }

    public Sequence[] bestSequences(int numSequences, Object[] sequence, Object[] additionalContext, double minSequenceScore) {
        int n = sequence.length;
        ListHeap prev = new ListHeap(this.size);
        ListHeap next = new ListHeap(this.size);
        prev.add(new Sequence());
        if (additionalContext == null) {
            additionalContext = EMPTY_ADDITIONAL_CONTEXT;
        }
        for (int i = 0; i < n; ++i) {
            int sz = Math.min(this.size, prev.size());
            for (int sc = 0; prev.size() > 0 && sc < sz; ++sc) {
                Sequence ns;
                String out;
                int p;
                double[] scores;
                Sequence top = (Sequence)prev.extract();
                List tmpOutcomes = top.getOutcomes();
                String[] outcomes = tmpOutcomes.toArray(new String[tmpOutcomes.size()]);
                String[] contexts = this.cg.getContext(i, sequence, outcomes, additionalContext);
                if (this.contextsCache != null) {
                    scores = (double[])this.contextsCache.get(contexts);
                    if (scores == null) {
                        scores = this.model.eval(contexts, this.probs);
                        this.contextsCache.put(contexts, scores);
                    }
                } else {
                    scores = this.model.eval(contexts, this.probs);
                }
                double[] temp_scores = new double[scores.length];
                for (int c = 0; c < scores.length; ++c) {
                    temp_scores[c] = scores[c];
                }
                Arrays.sort(temp_scores);
                double min = temp_scores[Math.max(0, scores.length - this.size)];
                for (p = 0; p < scores.length; ++p) {
                    if (scores[p] < min || !this.validSequence(i, sequence, outcomes, out = this.model.getOutcome(p)) || !((ns = new Sequence(top, out, scores[p])).getScore() > minSequenceScore)) continue;
                    next.add(ns);
                }
                if (next.size() != 0) continue;
                for (p = 0; p < scores.length; ++p) {
                    out = this.model.getOutcome(p);
                    if (!this.validSequence(i, sequence, outcomes, out) || !((ns = new Sequence(top, out, scores[p])).getScore() > minSequenceScore)) continue;
                    next.add(ns);
                }
            }
            prev.clear();
            ListHeap tmp = prev;
            prev = next;
            next = tmp;
        }
        int numSeq = Math.min(numSequences, prev.size());
        Sequence[] topSequences = new Sequence[numSeq];
        for (int seqIndex = 0; seqIndex < numSeq; ++seqIndex) {
            topSequences[seqIndex] = (Sequence)prev.extract();
        }
        return topSequences;
    }

    public Sequence bestSequence(List sequence, Object[] additionalContext) {
        return this.bestSequences(1, sequence.toArray(), additionalContext)[0];
    }

    public Sequence bestSequence(Object[] sequence, Object[] additionalContext) {
        return this.bestSequences(1, sequence, additionalContext, -100000.0)[0];
    }

    protected boolean validSequence(int i, Object[] inputSequence, String[] outcomesSequence, String outcome) {
        return true;
    }
}

