/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lang.spanish;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.tools.sentdetect.SentenceDetectorME;

public class SentenceDetector
extends SentenceDetectorME {
    public SentenceDetector(String name) throws IOException {
        super((MaxentModel)new SuffixSensitiveGISModelReader(new File(name)).getModel());
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.print("Usage java opennlp.tools.lang.spanish.SentenceDetector model < text");
            System.exit(1);
        }
        SentenceDetector sdetector = new SentenceDetector(args[0]);
        StringBuffer para = new StringBuffer();
        BufferedReader inReader = new BufferedReader(new InputStreamReader(System.in, "ISO-8859-1"));
        PrintStream out = new PrintStream((OutputStream)System.out, true, "ISO-8859-1");
        String line = inReader.readLine();
        while (line != null) {
            if (line.equals("")) {
                if (para.length() != 0) {
                    String[] sents = sdetector.sentDetect(para.toString());
                    int sn = sents.length;
                    for (int si = 0; si < sn; ++si) {
                        out.println(sents[si]);
                    }
                }
                out.println();
                para.setLength(0);
            } else {
                para.append(line).append(" ");
            }
            line = inReader.readLine();
        }
        if (para.length() != 0) {
            String[] sents = sdetector.sentDetect(para.toString());
            int sn = sents.length;
            for (int si = 0; si < sn; ++si) {
                out.println(sents[si]);
            }
        }
    }
}

