% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_pccs.R
\name{print.opaGroupComparison}
\alias{print.opaGroupComparison}
\title{Prints a summary of results from hypothesis comparison.}
\usage{
\method{print}{opaGroupComparison}(x, ...)
}
\arguments{
\item{x}{an object of class "opaHypothesisComparison".}

\item{...}{ignored}
}
\value{
No return value, called for side effects.
}
\description{
Prints a summary of results from hypothesis comparison.
}
\examples{
dat <- data.frame(group = c("a", "b", "a", "b"),
                  t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11))
dat$group <- factor(dat$group, levels = c("a", "b"))
h <- hypothesis(1:3)
opamod <- opa(dat[,2:4], h, group = dat$group)
z <- compare_groups(opamod, "a", "b")
print(z)
}
