% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_pccs.R
\name{compare_groups}
\alias{compare_groups}
\title{Calculate the c-value of the difference in PCCs produced by two groups}
\usage{
compare_groups(m, group1, group2)
}
\arguments{
\item{m}{an object of class "opafit" produced by a call to opa().}

\item{group1}{a character string which matches a group level passed to opa().}

\item{group2}{a character string which matches a group level passed to opa().}
}
\value{
a list with the following elements

\describe{
  \item{pcc_diff}{A double. The absolute difference between group PCCs.}
  \item{cval}{The chance that an absolute difference between
  PCCs generated by random ordering is greater than or equal to the
  difference in observed group PCCs.}
  }
}
\description{
Calculate the c-value of the difference in PCCs produced by two groups
}
\examples{
dat <- data.frame(group = c("a", "b", "a", "b"),
                  t1 = c(9, 4, 8, 10),
                  t2 = c(8, 8, 12, 10),
                  t3 = c(8, 5, 10, 11))
dat$group <- factor(dat$group, levels = c("a", "b"))
opamod <- opa(dat[,2:4], 1:3, group = dat$group)
compare_groups(opamod, "a", "b")
}
