% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cull.r
\name{cull}
\alias{cull}
\title{Force objects to have length or rows equal to the shortest}
\usage{
cull(...)
}
\arguments{
\item{...}{Vectors, matrices, or data frames.}
}
\value{
A list with one element per object supplied as an argument to the function.
}
\description{
This function takes a set of vectors, data frames, or matrices and removes the last values/rows so that they all have a length/number of rows equal to the shortest among them.
}
\examples{
a <- 1:10
b <- 1:20
c <- letters
cull(a, b, c)
x <- data.frame(x=1:10, y=letters[1:10])
y <- data.frame(x=1:26, y=letters)
cull(x, y)
}
