% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowColIndexing.r
\name{rowColIndexing}
\alias{rowColIndexing}
\title{Convert between row- and column-style indexing of matrices}
\usage{
rowColIndexing(x, cell, dir)
}
\arguments{
\item{x}{Either a matrix or a vector with two values, one for the number of rows and one for the number of columns in a matrix.}

\item{cell}{One or more cell indices (positive integers).}

\item{dir}{The "direction" in which to convert. If \code{'row'}, it is assumed that \code{cell} is a column-style index and so should be converted to a row-style index. If \code{'col'}, it is assumed that \code{cell} is a row-style index and so should be converted to a column-style index.}
}
\value{
One or more positive integers.
}
\description{
These functions converts index values of cells between row- and column-style indexing of cells in matrices. Column indexing (the default for matrices) has the cell "1" in the upper left corner of the matrix. The cell "2" is below it, and so on. The numbering then wraps around to the top of the next column. Row indexing (the default for rasters, for example), also has cell "1" in the upper left, but cell "2" is to its right, and so on. Numbering then wraps around to the next row.
}
\examples{

# column versus row indexing
colIndex <- matrix(1:40, nrow=5, ncol=8)
rowIndex <- matrix(1:40, nrow=5, ncol=8, byrow=TRUE)
colIndex
rowIndex

# examples
x <- matrix('a', nrow=5, ncol=8, byrow=TRUE)
rowColIndexing(x, cell=c(1, 6, 20), 'row')
rowColIndexing(x, cell=c(1, 6, 20), 'col')

rowColIndexing(c(5, 8), cell=c(1, 6, 20), 'row')
rowColIndexing(c(5, 8), cell=c(1, 6, 20), 'col')

}
