% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-forward-regression.R
\name{ols_step_forward_p}
\alias{ols_step_forward_p}
\alias{ols_step_forward_p.default}
\alias{plot.ols_step_forward_p}
\title{Stepwise forward regression}
\usage{
ols_step_forward_p(model, ...)

\method{ols_step_forward_p}{default}(
  model,
  p_val = 0.3,
  include = NULL,
  exclude = NULL,
  hierarchical = FALSE,
  progress = FALSE,
  details = FALSE,
  ...
)

\method{plot}{ols_step_forward_p}(x, model = NA, print_plot = TRUE, details = TRUE, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other arguments.}

\item{p_val}{p value; variables with p value less than \code{p_val} will
enter into the model}

\item{include}{Character or numeric vector; variables to be included in selection process.}

\item{exclude}{Character or numeric vector; variables to be excluded from selection process.}

\item{hierarchical}{Logical; if \code{TRUE}, performs hierarchical selection.}

\item{progress}{Logical; if \code{TRUE}, will display variable selection progress.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_forward_p}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_step_forward_p} returns an object of class \code{"ols_step_forward_p"}.
An object of class \code{"ols_step_forward_p"} is a list containing the
following components:

\item{model}{final model; an object of class \code{lm}}
\item{metrics}{selection metrics}
}
\description{
Build regression model from a set of candidate predictor variables by
entering predictors based on p values, in a stepwise manner until there is
no variable left to enter any more.
}
\examples{
# stepwise forward regression
model <- lm(y ~ ., data = surgical)
ols_step_forward_p(model)

# stepwise forward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_forward_p(model)
plot(k)

# selection metrics
k$metrics

# final model
k$model

# include or exclude variables
# force variable to be included in selection process
ols_step_forward_p(model, include = c("age", "alc_mod"))

# use index of variable instead of name
ols_step_forward_p(model, include = c(5, 7))

# force variable to be excluded from selection process
ols_step_forward_p(model, exclude = c("pindex"))

# use index of variable instead of name
ols_step_forward_p(model, exclude = c(2))

# hierarchical selection
model <- lm(y ~ bcs + alc_heavy + pindex + enzyme_test, data = surgical)
ols_step_forward_p(model, 0.1, hierarchical = TRUE)

# plot
k <- ols_step_forward_p(model, 0.1, hierarchical = TRUE)
plot(k)

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.

Kutner, MH, Nachtscheim CJ, Neter J and Li W., 2004, Applied Linear Statistical Models (5th edition).
Chicago, IL., McGraw Hill/Irwin.
}
\seealso{
Other forward selection procedures: 
\code{\link{ols_step_forward_adj_r2}()},
\code{\link{ols_step_forward_aic}()},
\code{\link{ols_step_forward_r2}()},
\code{\link{ols_step_forward_sbc}()},
\code{\link{ols_step_forward_sbic}()}
}
\concept{forward selection procedures}
