% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-potential-residual-plot.R
\name{ols_plot_resid_pot}
\alias{ols_plot_resid_pot}
\title{Potential residual plot}
\usage{
ols_plot_resid_pot(model, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\description{
Plot to aid in classifying unusual observations as high-leverage points,
outliers, or a combination of both.
}
\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_plot_resid_pot(model)

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
\seealso{
\code{\link[=ols_plot_hadi]{ols_plot_hadi()}}
}
