context('stepwise backward regression output')

model <- lm(y ~ ., data = surgical)

test_that('output from stepwise backward regression is as expected', {

  x <- cat("Backward Elimination Method                                                

Candidate Terms:                                                           

1 . bcs                                                                    
2 . pindex                                                                 
3 . enzyme_test                                                            
4 . liver_test                                                             
5 . age                                                                    
6 . gender                                                                 
7 . alc_mod                                                                
8 . alc_heavy                                                              

--------------------------------------------------------------------------
                           Elimination Summary                             
--------------------------------------------------------------------------
        Variable                  Adj.                                        
Step    Removed     R-Square    R-Square     C(p)       AIC         RMSE      
--------------------------------------------------------------------------
   1    alc_mod       0.7818      0.7486    7.0141    734.4068    199.2637    
   2    gender        0.7814      0.7535    5.0870    732.4942    197.2921    
   3    age           0.7809      0.7581    3.1925    730.6204    195.4544    
--------------------------------------------------------------------------")

  expect_equivalent(print(ols_step_backward(model)), x)

})


test_that('output from stepwise backward regression is as expected when details == TRUE', {

  x <- cat("Backward Elimination: Step 1 

 Variable alc_mod Removed 

                          Model Summary                           
-----------------------------------------------------------------
R                       0.884       RMSE                 199.264 
R-Squared               0.782       Coef. Var             28.381 
Adj. R-Squared          0.749       MSE                39706.040 
Pred R-Squared          0.678       MAE                  137.053 
-----------------------------------------------------------------
 RMSE: Root Mean Square Error 
 MSE: Mean Square Error 
 MAE: Mean Absolute Error 

                                 ANOVA                                  
-----------------------------------------------------------------------
                   Sum of                                              
                  Squares        DF    Mean Square      F         Sig. 
-----------------------------------------------------------------------
Regression    6543042.709         7     934720.387    23.541    0.0000 
Residual      1826477.828        46      39706.040                     
Total         8369520.537        53                                    
-----------------------------------------------------------------------

                                      Parameter Estimates                                        
------------------------------------------------------------------------------------------------
      model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
------------------------------------------------------------------------------------------------
(Intercept)    -1145.971       238.536                 -4.804    0.000    -1626.119    -665.822 
        bcs       62.274        24.187        0.251     2.575    0.013       13.589     110.959 
     pindex        8.987         1.850        0.382     4.857    0.000        5.262      12.711 
enzyme_test        9.875         1.720        0.528     5.743    0.000        6.414      13.337 
 liver_test       50.763        44.379        0.137     1.144    0.259      -38.567     140.093 
        age       -0.911         2.599       -0.025    -0.351    0.728       -6.142       4.320 
     gender       15.786        57.840        0.020     0.273    0.786     -100.639     132.212 
  alc_heavy      315.854        73.849        0.312     4.277    0.000      167.202     464.505 
------------------------------------------------------------------------------------------------


Backward Elimination: Step 2 

 Variable gender Removed 

                          Model Summary                           
-----------------------------------------------------------------
R                       0.884       RMSE                 197.292 
R-Squared               0.781       Coef. Var             28.101 
Adj. R-Squared          0.754       MSE                38924.162 
Pred R-Squared          0.692       MAE                  138.160 
-----------------------------------------------------------------
 RMSE: Root Mean Square Error 
 MSE: Mean Square Error 
 MAE: Mean Absolute Error 

                                 ANOVA                                  
-----------------------------------------------------------------------
                   Sum of                                              
                  Squares        DF    Mean Square      F         Sig. 
-----------------------------------------------------------------------
Regression    6540084.920         6    1090014.153    28.004    0.0000 
Residual      1829435.617        47      38924.162                     
Total         8369520.537        53                                    
-----------------------------------------------------------------------

                                      Parameter Estimates                                        
------------------------------------------------------------------------------------------------
      model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
------------------------------------------------------------------------------------------------
(Intercept)    -1143.080       235.943                 -4.845    0.000    -1617.737    -668.424 
        bcs       61.424        23.748        0.248     2.586    0.013       13.649     109.199 
     pindex        8.974         1.832        0.382     4.900    0.000        5.290      12.659 
enzyme_test        9.852         1.700        0.527     5.794    0.000        6.431      13.273 
 liver_test       54.053        42.288        0.146     1.278    0.207      -31.019     139.125 
        age       -0.850         2.563       -0.024    -0.332    0.742       -6.007       4.307 
  alc_heavy      314.585        72.974        0.310     4.311    0.000      167.781     461.390 
------------------------------------------------------------------------------------------------


Backward Elimination: Step 3 

 Variable age Removed 

                          Model Summary                           
-----------------------------------------------------------------
R                       0.884       RMSE                 195.454 
R-Squared               0.781       Coef. Var             27.839 
Adj. R-Squared          0.758       MSE                38202.426 
Pred R-Squared          0.700       MAE                  137.656 
-----------------------------------------------------------------
 RMSE: Root Mean Square Error 
 MSE: Mean Square Error 
 MAE: Mean Absolute Error 

                                 ANOVA                                  
-----------------------------------------------------------------------
                   Sum of                                              
                  Squares        DF    Mean Square      F         Sig. 
-----------------------------------------------------------------------
Regression    6535804.090         5    1307160.818    34.217    0.0000 
Residual      1833716.447        48      38202.426                     
Total         8369520.537        53                                    
-----------------------------------------------------------------------

                                      Parameter Estimates                                        
------------------------------------------------------------------------------------------------
      model         Beta    Std. Error    Std. Beta      t        Sig         lower       upper 
------------------------------------------------------------------------------------------------
(Intercept)    -1178.330       208.682                 -5.647    0.000    -1597.914    -758.746 
        bcs       59.864        23.060        0.241     2.596    0.012       13.498     106.230 
     pindex        8.924         1.808        0.380     4.935    0.000        5.288      12.559 
enzyme_test        9.748         1.656        0.521     5.887    0.000        6.419      13.077 
 liver_test       58.064        40.144        0.156     1.446    0.155      -22.652     138.779 
  alc_heavy      317.848        71.634        0.314     4.437    0.000      173.818     461.878 
------------------------------------------------------------------------------------------------


No more variables satisfy the condition of prem: 0.3
Backward Elimination Method                                                

Candidate Terms:                                                           

1 . bcs                                                                    
2 . pindex                                                                 
3 . enzyme_test                                                            
4 . liver_test                                                             
5 . age                                                                    
6 . gender                                                                 
7 . alc_mod                                                                
8 . alc_heavy                                                              

--------------------------------------------------------------------------
                           Elimination Summary                             
--------------------------------------------------------------------------
        Variable                  Adj.                                        
Step    Removed     R-Square    R-Square     C(p)       AIC         RMSE      
--------------------------------------------------------------------------
   1    alc_mod       0.7818      0.7486    7.0141    734.4068    199.2637    
   2    gender        0.7814      0.7535    5.0870    732.4942    197.2921    
   3    age           0.7809      0.7581    3.1925    730.6204    195.4544    
--------------------------------------------------------------------------")

  expect_equivalent(print(ols_step_backward(model, details = TRUE)), x)

})