% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-information-criteria.R
\name{ols_apc}
\alias{ols_apc}
\title{Amemiya's Prediction Criterion}
\usage{
ols_apc(model)
}
\arguments{
\item{model}{an object of class \code{lm}}
}
\value{
Amemiya's prediction error
}
\description{
Amemiya's prediction error
}
\details{
Amemiya's Prediction Criterion penalizes R-squared more heavily than does adjusted R-squared for
each addition degree of freedom used on the right-hand-side of the equation.  The higher the better for
this criterion.

\deqn{((n + p) / (n - p))(1 - (R^2))}

where \emph{n} is the sample size, \emph{p} is the number of predictors including the intercept and
\emph{R^2} is the coefficient of determination.
}
\examples{
model <- lm(mpg ~ disp + hp + wt + qsec, data = mtcars)
ols_apc(model)
}
\references{
Amemiya, T. (1976). Selection of Regressors. Technical Report 225, Stanford University, Stanford, CA.

Judge, G. G., Griffiths, W. E., Hill, R. C., and Lee, T.-C. (1980). The Theory and Practice of Econometrics.
New York: John Wiley & Sons.
}
