% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-modifiedFunctions.R
\name{.cc_urb_occTest}
\alias{.cc_urb_occTest}
\title{Flag values in urban areas (based on coordinate cleaner but modified for occTest to deliver it quitely)}
\usage{
.cc_urb_occTest(
  x,
  lon = "decimallongitude",
  lat = "decimallatitude",
  ref = NULL,
  value = "clean",
  verbose = FALSE,
  outdir
)
}
\arguments{
\item{x}{Data.frame of species occurrences}

\item{lon}{character. Column name in x with decimal longitude values}

\item{lat}{character. Column name in x with decimal latitude values}

\item{value}{character string. Defining the output value. See value.}

\item{verbose}{logical. If TRUE reports the name of the test and the number of records flagged}

\item{outdir}{output directory}

\item{a}{SpatialPolygonsDataFrame. Providing the geographic gazetteer with the urban areas. See details. By default rnaturalearth::ne_download(scale = 'medium', type = 'urban_areas'). Can be any SpatialPolygonsDataframe, but the structure must be identical to rnaturalearth::ne_download().}
}
\value{
a clean data.frame
}
\description{
flags values for urban areas
}
\references{
CoordinateCleaner package
}
\seealso{
\link[CoordinateCleaner]{cc_urb}
}
\author{
A Zizka (original function) Josep M Serra-Diaz (adaptation to occTest pep.serradiaz@agroparistech.fr)
}
\keyword{internal}
