% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{countryStatusRangeAnalysis}
\alias{countryStatusRangeAnalysis}
\title{Range analysis}
\usage{
countryStatusRangeAnalysis(
  df,
  xf,
  yf,
  .ntv.ctry,
  .inv.ctry,
  .c.field,
  .points.proj4string,
  .countries.shapefile,
  cfsf,
  excludeUnknownRanges = FALSE,
  excludeNotmatchCountry = FALSE,
  doRangeAnalysis = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{df}{data.frame of species occurrences}

\item{xf}{character. The field in the data.frame containing the x coordinates}

\item{yf}{character. The field in the data.frame containing the y coordinates}

\item{.ntv.ctry}{character. Native country in ISO3 coding}

\item{.inv.ctry}{character. Invasive country in ISO3 coding}

\item{.c.field}{character. Country field in the species data.frame (df)}

\item{.points.proj4string}{Proj4string for the occurrence data}

\item{.countries.shapefile}{spatialPolygonDataFrame of political divisions}

\item{cfsf}{character. Column name of the .country spatialPolygonDataFrame indicaing the country in ISO3 codeing.}

\item{excludeUnknownRanges}{logical. Should records be filtered if located in countries outside .ntv.ctry or .inv.ctry? Defalut FALSE}

\item{excludeNotmatchCountry}{Should records be if the reported country is different than the locatoin country? . Default FALSE}

\item{doRangeAnalysis}{logical. Should range analysis be performed?}

\item{verbose}{logical. Print messages? Default FALSE}
}
\value{
list
}
\description{
Identify and filter species records based on countries where species is considered native or alien.
}
\details{
It returns a list with two elements: stay (records that are excluded/filtered), continue (records that are not excluded from the filtering process)
}
\seealso{
Other analysis: 
\code{\link{.nearestcell3}()},
\code{\link{centroidDetection}()},
\code{\link{duplicatesexcludeAnalysis}()},
\code{\link{geoEnvAccuracy}()},
\code{\link{humanDetection}()}
}
\author{
Josep M Serra-Diaz (pep.serradiaz@agroparistech.fr)
}
\concept{analysis}
\keyword{internal}
