% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-modifiedFunctions.R
\name{.cc_outl_occTest}
\alias{.cc_outl_occTest}
\title{Identify geographic outliers based on methods from CoordinateCleaner package}
\usage{
.cc_outl_occTest(
  x,
  lon = "decimallongitude",
  lat = "decimallatitude",
  species = "species",
  method = "quantile",
  mltpl = 5,
  tdi = 1000,
  value = "clean",
  sampling_thresh = 0,
  verbose = TRUE,
  min_occs = 7,
  thinning = FALSE,
  thinning_res = 0.5
)
}
\arguments{
\item{x}{Data.frame of species occurrences}

\item{lon}{character. Column name in x with decimal longitude values}

\item{lat}{character. Column name in x with decimal latitude values}

\item{species}{character. Species name.}

\item{method}{character. Quantile by default}

\item{mltpl}{integer. Multiplication factor. Default to 5}

\item{tdi}{numeric. Default to 1000}

\item{value}{character. Type of output. Default to 'clean'}

\item{sampling_thresh}{numeric. Sampling threshold. Defaults to 0}

\item{verbose}{logical. Should output messages be printed. Default to TRUE}

\item{min_occs}{integer. Minimum number of occurrences. Defaults to 7}

\item{thinning}{logical. Should thinning be performed? Defaults to FALSE}

\item{thinning_res}{double. Thinnning resolution. Defaults to 0.5}
}
\value{
a clean data.frame
}
\description{
own version of coordinate cleaner geographic outliers
}
\author{
A Zizka (original function) Josep M Serra-Diaz (adaptation to occTest pep.serradiaz@agroparistech.fr)
}
\keyword{internal}
