% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuts_aggregate.R
\name{nuts_aggregate}
\alias{nuts_aggregate}
\title{Aggregate to higher order NUTS levels}
\usage{
nuts_aggregate(
  data,
  to_level,
  variables,
  weight = NULL,
  missing_rm = FALSE,
  missing_weights_pct = FALSE,
  multiple_versions = c("error", "most_frequent")
)
}
\arguments{
\item{data}{A nuts.classified object returned by \code{\link[=nuts_classify]{nuts_classify()}}.}

\item{to_level}{Number corresponding to the desired NUTS level to be aggregated to: \code{1} or \code{2}.}

\item{variables}{Named character specifying variable names and variable type (\code{'absolute'} or \code{'relative'}), e.g. \code{c('var_name' = 'absolute')}.}

\item{weight}{String with name of the weight used for conversion. Can be area size \code{'areaKm'} (default),
population in 2011 \code{'pop11'} or 2018 \code{'pop18'}, or artificial surfaces in 2012 \code{'artif_surf12'} and 2018 \code{'artif_surf18'}.}

\item{missing_rm}{Boolean that is FALSE by default. TRUE removes regional flows that depart from missing NUTS codes.}

\item{missing_weights_pct}{Boolean that is FALSE by default. TRUE computes the percentage of missing weights due to missing departing NUTS regions for each variable.}

\item{multiple_versions}{By default equal to \code{'error'}, when providing multiple NUTS versions within groups.
If set to \code{'most_frequent'} data is converted using the best-matching NUTS version.}
}
\value{
A tibble containing NUTS codes, aggregated variable values, and possibly grouping variables.
}
\description{
\code{nuts_aggregate()} transforms regional NUTS data between NUTS levels.
}
\details{
Console messages can be controlled with \code{rlang::local_options(nuts.verbose = "quiet")} to silence messages and
\code{nuts.verbose = "verbose"} to switch messages back on.
}
\examples{
library(dplyr)

# Load EUROSTAT data of manure storage deposits
data(manure)

# Data varies at the NUTS level x indicator x year x country x NUTS code level
head(manure)

# Aggregate from NUTS 3 to 2 by indicator x year
manure \%>\%
  filter(nchar(geo) == 5) \%>\%
  nuts_classify(nuts_code = "geo",
                group_vars = c('indic_ag','time')) \%>\%
  # Group vars are automatically passed on
  nuts_aggregate(to_level = 2,
                 variables = c('values'= 'absolute'),
                 weight = 'pop18')

}
