% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_list.R
\name{f_list}
\alias{f_list}
\alias{f_list_amp}
\alias{ff_list}
\title{Format List Series}
\usage{
f_list(x, and = "and", oxford = TRUE, ...)

f_list_amp(x, and = "&", oxford = TRUE, ...)

ff_list(...)
}
\arguments{
\item{x}{A vector of values to turn into a collapsed series.}

\item{and}{The value to use for the 'and'.  Commonly \code{'and'} and
\code{'&'} are used.}

\item{oxford}{logical.  If \code{TRUE} an oxford comma is used.  If you use
\code{FALSE} you are a monster.}

\item{\ldots}{ignored.}
}
\value{
Returns a string that is a list series.
}
\description{
\code{f_list} - Format a vector of elements as a list series
(e.g., \code{c('A', 'B', 'C')} becomes \code{"A, B, and C"}).

\code{f_list_amp} - A ampersand wrapper for \code{f_list} with
\code{and = '&'} set by default.
}
\examples{
f_list(1)
f_list(1:2)
f_list(1:3)
f_list(1:5)

x <- c("parents", "Lady Gaga",  "Humpty Dumpty")
## Three things you love
sprintf('I love my \%s.', f_list(x))
## Your parents are lady Gaga & Humpty Dumpty?????
sprintf('I love my \%s.', f_list(x, oxford = FALSE))

sprintf('I love my \%s.', f_list(x, and = '&'))
sprintf('I love my \%s.', f_list_amp(x))
}
