% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dollar.R
\name{f_dollar}
\alias{f_dollar}
\alias{ff_dollar}
\title{Format Dollars}
\usage{
f_dollar(x, leading_zero = TRUE, digits = 2, ...)

ff_dollar(...)
}
\arguments{
\item{x}{A vector of values.}

\item{leading_zero}{logical.  If \code{TRUE} a leading zero will be added to
values from 0 up to 1.}

\item{digits}{The number of digits to use.  Defaults to 2.  Can be set
globally via: \code{options(numformdigits = n)} where n is the number of
digits beyond the decimal point to include.}

\item{\ldots}{Other values passed to \code{\link[numform]{f_num}}.}
}
\value{
Returns a string of publication ready digits.
}
\description{
\code{f_dollar} - A wrapper for \code{\link[numform]{f_num}} that formats
dollar values as labeled dollars.
}
\examples{
f_dollar(c(30, 33.45, .1))
\dontrun{
library(dplyr)
f_dollar(c(0.0, 0, .2, -00.02, 1122222, pi)) \%>\% f_comma()
}
}
\seealso{
\code{\link[numform]{f_num}}
}
