% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_diff.r
\name{calc_diff}
\alias{calc_diff}
\title{Calculating the difference between true plot and the null plot with the maximum distance.}
\usage{
calc_diff(lineup.dat, var, met, pos, dist.arg = NULL, m = 20)
}
\arguments{
\item{lineup.dat}{lineup data to get the lineup}

\item{var}{a vector of names of the variables to be used to calculate the difference}

\item{met}{distance metric needed to calculate the distance as a character}

\item{pos}{position of the true plot in the lineup}

\item{dist.arg}{a list or vector of inputs for the distance metric met; NULL by default}

\item{m}{number of plots in the lineup, by default m = 20}
}
\value{
difference between the mean distance of the true plot and
the maximum mean distance of the null plots
}
\description{
Distance metric is used to calculate the mean distance between the true plot
and all the null plots in a lineup. The difference between the mean
distance of the true plot and the maximum mean distance of the null plots is
calculated.
}
\examples{
if(require('dplyr')){
lineup.dat <- lineup(null_permute('mpg'), mtcars, pos = 1)
calc_diff(lineup.dat, var = c('mpg', 'wt'), met = 'bin_dist',
dist.arg = list(lineup.dat = lineup.dat, X.bin = 5, Y.bin = 5), pos = 1, m = 8)}

if(require('dplyr')){
calc_diff(lineup(null_permute('mpg'), mtcars, pos = 1), var = c('mpg', 'wt'), met = 'reg_dist',
dist.arg = NULL, pos = 1, m = 8)}
}
