% Generated by roxygen2 (4.0.2): do not edit by hand
\name{distmet}
\alias{distmet}
\title{Empirical distribution of the distance}
\usage{
distmet(lineup.dat, var, met, method, pos, repl = 1000, dist.arg = NULL,
  m = 20)
}
\arguments{
\item{lineup.dat}{lineup data}

\item{var}{a vector of names of the variables to be used}

\item{met}{distance metric needed to calculate the distance as a character}

\item{method}{method for generating null data sets}

\item{pos}{position of the observed data in the lineup}

\item{repl}{number of sets of null plots selected to obtain the distribution; 1000 by
default}

\item{dist.arg}{a list or vector of inputs for the distance metric met; NULL by default}

\item{m}{the number of plots in the lineup; m = 20 by default}
}
\value{
lineup has the data used for the caulations

null_values contains new null samples from which to compare nulls in lineup

diff difference in distance between nulls and actual data and that of the null
that is most different from other nulls. A negative value means that the actual data
plot is similar to the null plots.

closest list of the five closest nulls to the actual data plot

pos position of the actual data plot in the lineup
}
\description{
The empirical distribution of the distance measures is calculated based on the mean
distance of each of the null plots from the other null plots in a lineup. At this moment
this method works only for \code{\link{null_permute}} method. This function helps get some
assessment of whether the actual data plot is very different from the null plots.
}
\examples{
if(require('dplyr')){
distmet(lineup(null_permute('mpg'), mtcars, pos = 1), var = c('mpg', 'wt'),
'reg_dist', null_permute('mpg'), pos = 1, repl = 100, m = 8)}

\donttest{
if(require('dplyr')){
distmet(lineup(null_permute('mpg'), mtcars, pos = 1), var = c('mpg', 'wt'),
'bin_dist', null_permute('mpg'), pos = 1, repl = 100,
dist.arg = list(lineup.dat = lineup.dat, X.bin = 5, Y.bin = 5))} }


lineup.dat <- lineup(null_permute('mpg'), mtcars)
qplot(mpg, wt, data = lineup.dat, geom = 'point') + facet_wrap(~ .sample)
#decrypt('...') # Copy and paste the output from lineup.dat to get the
#position of the true plot
#[1] 'True data in position 4' # Use pos = 4
if(require('dplyr')){
distmet(lineup.dat, var = c('mpg', 'wt'), 'bin_dist', null_permute('mpg'),
pos = 4, repl = 100, dist.arg = list(lineup.dat = lineup.dat, X.bin = 5,
Y.bin = 5), m = 8)}

# Example using uni_dist
\donttest{
mod <- lm(wt ~ mpg, data = mtcars)
resid.dat <- data.frame(residual = mod$resid)
lineup.dat <- lineup(null_dist('residual', dist = 'normal'), resid.dat)
qplot(residual, data = lineup.dat, geom = 'histogram', binwidth = 0.25) +
facet_wrap(~ .sample)
#decrypt('....') #Copy and paste to get the true position
if(require('dplyr')){
distmet(lineup.dat, var = 'residual', 'uni_dist', null_dist('residual',
dist = 'normal'), pos = 19, repl = 100)}
# Assuming pos = 19; but put the true position for pos
}
}

