% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/006functions.R
\name{pseudoR}
\alias{pseudoR}
\title{pseudo R^2}
\usage{
pseudoR(
  x,
  which = c("all", "McFadden", "adjMcFadden", "Cox&Snell", "Nagelkerke"),
  only_total = FALSE
)
}
\arguments{
\item{x}{Fitted \code{nmm} model.}

\item{which}{which pseudo R^2 to calculate, options are:
"all", "McFadden", "adjMcFadden", "Cox&Snell","Nagelkerke".}

\item{only_total}{If \code{TRUE}, compute R^2 only for the whole sample.}
}
\value{
matrix with goodness of fit measures
}
\description{
Calculates pseudo R^2 for discrete choice part.
}
\examples{
library(mlogit)
data("Fishing", package = "mlogit")
Fish <- mlogit.data(Fishing, varying = c(2:9), shape = "wide", choice = "mode")
## a pure "conditional" model
mres <- summary(mlogit(mode ~ price + catch, data = Fish))
data <- prepare_data(Fish \%>\% data.frame \%>\% dplyr::select(-idx),
choice="alt", dummy="mode", PeID="chid", mode_spec_var = c("price", "catch"),
type="long")
eq_d <- c("a1 + p1 * price_1 + p2 * catch_2", "a2 + p1 * price_2 + p2 * catch_2",
             "a3 + p1 * price_3 + p2 * catch_3", "a4 + p1 * price_4 + p2 * catch_4")
par_d <- c(paste0("a", 1:4), paste0("p", 1:2))
res <- nmm(data, eq_d=eq_d, par_d = par_d,  eq_type="disc", fixed_term=FALSE,
best_method=FALSE)
pseudoR(res, which = c("McFadden"))
ncf <- c(mres$coefficients)
names(ncf) <- par_d[-1]
mress <- in2nmm(res, new_coef =  ncf)
pseudoR(mress, which = c("McFadden"))
pseudoR(mress)
}
