% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_best_params.R
\name{get_best_params}
\alias{get_best_params}
\title{Get best-fit parameters}
\usage{
get_best_params(
  dat,
  form,
  functions,
  nlparam,
  lp,
  lp_bounds = NULL,
  lhs_var,
  N = 10,
  quiet = TRUE,
  parallel = FALSE
)
}
\arguments{
\item{dat}{Data frame with the data points to be fitted.}

\item{form}{A formula given in the form "LHS ~ a1 * F_1(x,p1) + a2 * F_2(x,p2) + ... + an F_n(x,pn)"}

\item{functions}{A string array with the nonlinear functions as obtained with \code{get_functions} functions.}

\item{nlparam}{A list with the names of the nonlinear parameters and their lower and upper bounds in the form \code{c(lower,upper)}.}

\item{lp}{A string array with the names of the linear parameters contained in the formula as obtained with \code{get_parameters} function}

\item{lp_bounds}{An optional list with the bounding restrictions over the linear parameters.}

\item{lhs_var}{The name of the left-hand-side of the formula}

\item{N}{Size of the partition of the nonlinear parameters. Defaults to 10.}

\item{quiet}{Logical. If TRUE (default) supresses any warnings regarding the collinearity of the columns of the matrix in the determination of the best linear parameters.}

\item{parallel}{Logical. If TRUE then multicore parallelization of for loops is done with the parallel package. Defaults to FALSE.}
}
\value{
A list containing the strings for the  nonlinear functions of the formula.
}
\description{
Returns the best-fit parameters for a given nonlinear parameter bounds and nonlinear functions.
}
\details{
This is an internal function called from  \code{nls_tac} function. It is not intended for direct use.
}
