% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MED.output_helper.R
\name{getMED.output}
\alias{getMED.output}
\title{Extract Point Estimates And Standard Errors of Longitudinal Mediation Model}
\usage{
getMED.output(model, y_var, m_var, x_type, x_var, curveFun, names)
}
\arguments{
\item{model}{An object representing a fitted longitudinal mediation model.}

\item{y_var}{A string specifying the prefix of the column names corresponding to the outcome variable at each study wave.
It takes the value passed from \code{getMediation()}.}

\item{m_var}{A string specifying the prefix of the column names corresponding to the mediator variable at each study wave.
It takes the value passed from \code{getMediation()}.}

\item{x_type}{A string indicating the type of predictor variable used in the model. Supported values are \code{"baseline"}
and \code{"longitudinal"}. It takes the value passed from \code{getMediation()}.}

\item{x_var}{A string specifying the baseline predictor if \code{x_type = "baseline"}, or the prefix of the column names
corresponding to the predictor variable at each study wave if \code{x_type = "longitudinal"}. It takes the value passed from
\code{getMediation()}.}

\item{curveFun}{A string specifying the functional form of the growth curve. Supported options include: \code{"linear"}
(or \code{"LIN"}), and \code{"bilinear spline"} (or \code{"BLS"}). It takes the value passed from \code{getMediation()}.}

\item{names}{A character vector specifying parameter names. It takes the value passed from \code{getMediation()}.}
}
\value{
A data frame containing the point estimates and standard errors for parameters of a longitudinal mediation model.
}
\description{
This function computes and returns a data frame containing point estimates and standard errors for the parameters of
a longitudinal mediation model.
}
\keyword{internal}
