% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_tables.R
\name{build_tables}
\alias{build_tables}
\title{Generates Tables  for an \code{nlmixr2} Report}
\usage{
build_tables(
  obnd = NULL,
  fit = NULL,
  rptdetails = NULL,
  cat_covars = NULL,
  cont_covars = NULL,
  verbose = TRUE
)
}
\arguments{
\item{obnd}{onbrand report object to have report elements appended to}

\item{fit}{nlmixr2 fit object to be reported}

\item{rptdetails}{object creating when reading in rptyaml file}

\item{cat_covars}{character vector of categorical covariates to overwrite defaults in yaml file}

\item{cont_covars}{character vector of continuous covariates to overwrite defaults in yaml file}

\item{verbose}{Boolean variable when set to TRUE (default) messages will be
displayed on the terminal}
}
\value{
List containing the tables with the following structure:
\itemize{
\item \code{"rpttabs"} - List of tables with names corresponding to the
table ids in the yaml file. It contains the elements from the yamle file
and the following elements:
\itemize{
\item \code{"table"}        - Result of build (t_res object)
\item \code{"orientation"}  - Table orientation ("portrait" or "landscape")
\item \code{"isgood"}       - Boolean variable indicating success or failure
\item \code{"skip"}         - Boolean variable indicating whether the table should be skipped during reporting
\item \code{"tmsgs"}        - Vector of messages
\item \code{"cmd"}          - Original plot generation command
\item \code{"cmd_proc"}     - Plot generation command after processing for placeholders
\item \code{"height"}       - Table height
\item \code{"width"}        - Table width
\item \code{"caption"}      - Caption for Word
\item \code{"caption_proc"} - Caption for Word after processing for placeholders
\item \code{"title"}        - Slide title for PowerPoint
\item \code{"title_proc"}   - Slide title for PowerPoint after processing for placeholders
}
\item \code{"isgood"} - Boolean variable indicating success or failure
\item \code{"msgs"} - Vector of messages
}
}
\description{
Creates tables specified in a rptyaml file
}
\examples{
# We need an onbrand object to use below
\donttest{
library(onbrand)  
obnd = read_template(
 template = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.docx"),
 mapping  = system.file(package="nlmixr2rpt", "templates","nlmixr_obnd_template.yaml"))

# We also need an nlmixr fit object
fit = fetch_fit_example()

# This reads in the report details as well
rptdetails = yaml_read_fit(
 obnd    = obnd,
 rptyaml = system.file(package="nlmixr2rpt", "examples", "report_fit_test.yaml"),
 fit     = fit)$rptdetails

# Now we will build the tables 
btres = build_tables(obnd        = obnd,
                     fit        = fit, 
                     rptdetails = rptdetails)
}
}
