% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynmodel.R
\name{as.focei.dynmodel}
\alias{as.focei.dynmodel}
\title{Output nlmixr format for dynmodel}
\usage{
\method{as.focei}{dynmodel}(
  .dynmodelObject,
  .nlmixrObject,
  .data,
  .time,
  .theta,
  .fit,
  .message,
  .inits.err,
  .cov,
  .sgy,
  .dynmodelControl,
  .nobs2 = 0,
  .pt = proc.time(),
  .rxControl = RxODE::rxControl()
)
}
\arguments{
\item{.dynmodelObject}{dynmodel object}

\item{.nlmixrObject}{nlmixr object}

\item{.data}{RxODE data set}

\item{.time}{proc.time object used in dynmodel timing}

\item{.theta}{estimated terms excluding error terms}

\item{.fit}{optimized parameters}

\item{.message}{optimization messages}

\item{.inits.err}{initial estimates for error terms}

\item{.cov}{covariance matrix from solved Hessian}

\item{.sgy}{variance of Y given the model}

\item{.dynmodelControl}{control options for dynmodel}

\item{.nobs2}{-}

\item{.pt}{proc.time object used in dynmodel timing}

\item{.rxControl}{control options for RxODE}
}
\value{
A UI version of a dynmodel object
}
\description{
Convert dynmodel output to nlmixr focei style output
}
\author{
Mason McComb and Matt Fidler
}
\keyword{internal}
