% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nlmixr.R
\name{saemControl}
\alias{saemControl}
\title{Control Options for SAEM}
\usage{
saemControl(seed = 99, n.burn = 200, n.em = 300, nmc = 3, nu = c(2, 2,
  2), atol = 1e-06, rtol = 1e-04, stiff = TRUE, transit_abs = FALSE,
  print = 1, ...)
}
\arguments{
\item{seed}{Random Seed for SAEM step.  (Needs to be set for
reproducibility.)  By default this is 99.}

\item{n.burn}{Number of iterations in the Stochastic Approximation
(SA), or burn-in step. This is equivalent to Monolix's \code{K_0} or \code{K_b}.}

\item{n.em}{Number of iterations in the Expectation-Maximization
(EM) Step. This is equivalent to Monolix's \code{K_1}.}

\item{nmc}{Number of Markov Chains. By default this is 3.  When
you increase the number of chains the numerical integration by
MC method will be more accurate at the cost of more
computation.  In Monolix this is equivalent to \code{L}}

\item{nu}{This is a vector of 3 integers. They represent the
    numbers of transitions of the three different kernels used in
    the Hasting-Metropolis algorithm.  The default value is \code{c(2,2,2)},
    representing 40 for each transition initially (each value is
    multiplied by 20).

    The first value represents the initial number of multi-variate
    Gibbs samples are taken from a normal distribution.

    The second value represents the number of uni-variate, or multi-
    dimensional random walk Gibbs samples are taken.

    The third value represents the number of bootstrap/reshuffling or
    uni-dimensional random samples are taken.}

\item{atol}{a numeric absolute tolerance (1e-8 by default) used
by the ODE solver to determine if a good solution has been
achieved;  This is also used in the solved linear model to check
if prior doses do not add anything to the solution.}

\item{rtol}{a numeric relative tolerance (1e-6 by default) used
by the ODE solver to determine if a good solution has been
achieved. This is also used in the solved linear model to check
 if prior doses do not add anything to the solution.}

\item{stiff}{a logical (\code{TRUE} by default) indicating whether
    the ODE system is stiff or not.

    For stiff ODE sytems (\code{stiff = TRUE}), \code{RxODE} uses the
    LSODA (Livermore Solver for Ordinary Differential Equations)
    Fortran package, which implements an automatic method switching
    for stiff and non-stiff problems along the integration
    interval, authored by Hindmarsh and Petzold (2003).

    For non-stiff systems (\code{stiff = FALSE}), \code{RxODE} uses
    DOP853, an explicit Runge-Kutta method of order 8(5, 3) of
    Dormand and Prince as implemented in C by Hairer and Wanner
    (1993).}

\item{transit_abs}{boolean indicating if this is a transit
compartment absorption}

\item{print}{The number it iterations that are completed before
anything is printed to the console.  By default, this is 1.}

\item{...}{Other arguments to control SAEM.}
}
\value{
List of options to be used in \code{\link{nlmixr}} fit for
    SAEM.
}
\description{
Control Options for SAEM
}
\author{
Wenping Wang & Matthew L. Fidler
}
