% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/focei.R
\name{rxFoceiInner}
\alias{rxFoceiInner}
\title{Solve the FOCEI inner problem}
\usage{
rxFoceiInner(object, ..., dv, eta, c.hess = NULL, eta.bak = NULL,
  estimate = TRUE, inner.opt = c("n1qn1", "lbfgs"), return.env = FALSE,
  add.grad = FALSE)
}
\arguments{
\item{object}{RxODE object}

\item{...}{values sent to rxFoceiEtaSetup and lbfgs}

\item{dv}{dependent variable}

\item{eta}{eta value}

\item{c.hess}{Hessian curvature matrix in compressed form (Used for n1qn1)}

\item{eta.bak}{backup eta value in case eta estimation fails}

\item{estimate}{Boolean indicating if the optimization should be
perfomed(TRUE), or just keep the eta, and calculate the Loglik
with fitted/posthoc attributes(FALSE).}

\item{inner.opt}{Inner optimization method; Either n1qn1 or lbfgs}

\item{return.env}{Return the environment instead of the llik.}

\item{add.grad}{Add A gradient attribute, if not present.}
}
\value{
Loglik with fitted and posthoc attributes
}
\description{
Solve the FOCEI inner problem
}
\author{
Matthew L. Fidler
}
\keyword{internal}
